#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/ParseStdin.pm /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:03 pnayak Exp $
#
# ParseStdin.pm
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      ParseStdin.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    afontana    11/12/04 - add limit to split
#    afontana    11/02/04 - afontana_service_beacon_ftp
#    sreddy      11/01/04 - Creation
#

package ParseStdin;

use strict;
use vars qw (%parameters);

@ParseStdin::ISA = ('Exporter');
@ParseStdin::EXPORT_OK = qw(
  initStdin
  getParameter
);


##
## Initialization.  This reads and parses STDIN.
##
##  Usage:  ParseStdin::initStdin();
##
sub initStdin
{
  while (<STDIN>) {
    chomp;
    my ($name, $value) = split /=/,$_,2;
    %parameters->{$name} = $value;
  }
};

##
## Determine whether the parameter exists.
##
## Usage: print "hello" unless (ParseStdin::hasParameter("foobar"));
##
sub hasParameter
{
  my $name = shift;
  return (exists (%parameters->{$name}));
}


##
## Get the value of the parameter.
## You may optionally pass a default value as the second parameter to
## the function.
##
## Usage: print ParseStdin::getParameter("foo", "bar");
##
sub getParameter
{
  my $name = shift;
  if (exists (%parameters->{$name})) {
    return (%parameters->{$name});
  } else {
    return shift;
  }
}

1;
