#!/bin/sh
# ------------------------------------------------------------
# Script : allprocs.sh
# Purpose: Fetch process stats
# Usage  : allprocs.sh 
# ------------------------------------------------------------
# nasounda : RFI backport of 7284070 
# vsekuboy : making pcpu to 0 for zombie process on sunos
# vsekuboy : adding Mac OS X changes
# vsekuboy : Removed HP-UX from this script because allprocs.pl
#            is used for HP
#
OSTYPE=`uname -s`
export OSTYPE

case $OSTYPE in
 SunOS) # setup the Solaris specific parameters
  # list processes ordered by PID
    ps -efo 'pid, ppid, pcpu, vsz, rss, etime, s' | tail +2 | sort -r | awk '{if ($7 == "Z" ) {$3="0.0";$6="00:00"}; print "em_result=" $1 "|" $2 "|" $3 "|" $4 "|" $5 "|" $6}'
  ;;
 Linux) # setup the Linux specific parameters
  # list processes ordered by PID
   ps -eao "pid ppid pcpu vsz rss etime s" | tail -n +2 | sort -r | awk '{print "em_result=" $1 "|" $2 "|" $3 "|" $4 "|" $5 "|" $6}'
  ;;
 Darwin) # setup the MAC OS X specific parameters
  # list processes ordered by PID
   ps awwxo "pid ppid pcpu vsz rss start" | tail +2 | sort -r | awk '{print "em_result=" $1 "|" $2 "|" $3 "|" $4 "|" $5 "|" $6}'
  ;;
esac
