#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/bcn_cleanLogs.pl /main/7 2010/04/12 07:48:08 thsu Exp $
#
# bcn_cleanLogs.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      bcn_cleanLogs.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    thsu        08/13/09 - add support to clean up ATSFetchlet's support
#                           files
#    andyao      01/25/08 - Creation
# 

use Getopt::Long; # set up to accept user input
use File::stat;
use File::Path;
use Time::localtime;

my %cmdLine = ();
# Parse the input parameters and put them in the cmdLine hash table
GetOptions(\%cmdLine,
           "ttl=i", "caller:s", "agentStateDir:s",
           "workDir:s", "logRedirect:s");

my $ttl     = $cmdLine{"ttl"};
my $caller  = $cmdLine{"caller"};
my $agentStateDir = $cmdLine{"agentStateDir"};
my $workDir = $cmdLine{"workDir"};
my $logRedirect = $cmdLine{"logRedirect"};

open (OUTPUT, ">>bcn_cleanLogs.log");

my $isRunningTest = 0;
if ( $logRedirect ne '' && $workDir ne '') {
    $isRunningTest = 1;
    print OUTPUT "directing test log to $logRedirect\n";
    open (TEST_OUTPUT, ">> $logRedirect");
}

print OUTPUT "*********************\n";
print OUTPUT "---INPUT Params:\n";
print OUTPUT "agentStateDir=$agentStateDir\n";
print OUTPUT "workDir=$workDir\n";
print OUTPUT "ttl=$ttl\n";
print OUTPUT "now=" . time . " or " . localizeTime(time) . "\n";
print OUTPUT "caller=$caller\n";
print OUTPUT "logRedirect=$logRedirect\n";
print OUTPUT "---END INPUT Params---\n";

# Test program to print out everything in the environment from the shell
if ( 1 == 0 ) {
print OUTPUT "ENV-------\n";
foreach $key (sort keys(%ENV)) {
  print OUTPUT "$key = $ENV{$key}\n";
}
print OUTPUT "END ENV-------\n";
}

#### Clean up ATSFetchlet artifacts ####
my $fetchletWorkDir;
my @deleteTokens;
if ($isRunningTest) {
  $fetchletWorkDir = $workDir;
  writeTestLog("ats fetchlet work directory: $fetchletWorkDir\n");
  @deleteTokens = <$workDir/delete/*.txt>;
} else {
  $fetchletWorkDir = <$agentStateDir/sysman/emd/ats_fetchlet>;
  writeTestLog("ats fetchlet work directory: $fetchletWorkDir\n");
  @deleteTokens = <$agentStateDir/sysman/emd/ats_fetchlet/delete/*.txt>;

}

foreach $deleteToken (@deleteTokens) {
    my @keys = getIDKeys($deleteToken);
    my $pathKey = getPathKey(@keys);
    writeTestLog("$deleteToken has pathKey '$pathKey'\n");
    my $fileKey = getFileKey(@keys);
    writeTestLog("$deleteToken has fileKey '$fileKey'\n");
    my $dbFileKey = getDBFileKey(@keys);
    writeTestLog("$deleteToken has dbFileKey '$dbFileKey'\n");
    my $mod_time = stat($deleteToken)->mtime();
    writeTestLog($deleteToken . " was last modified at " . localizeTime($mod_time) . "\n");

    my $isDelete = 0;
    my $zipFile;
    if ($fileKey ne '') {
        $zipFile = $fetchletWorkDir . '/' . $fileKey;
        $isDelete = canDelete($deleteToken, $zipFile);
    }

    my $dbZipFile;
    if ($dbFileKey ne '') {
        $dbZipFile = $fetchletWorkDir . '/' . $dbFileKey;
    }


    my $unzipPath;
    if ($isDelete) {
        $unzipPath = $fetchletWorkDir . '/' . $pathKey;
        writeTestLog("Delete $unzipPath\n");
        rmtree($unzipPath);
        writeTestLog("Delete $zipFile\n");
        rmtree($zipFile);
        writeTestLog("Delete $dbZipFile\n");
        rmtree($dbZipFile);
        writeTestLog("Delete $deleteToken\n");
        rmtree($deleteToken);
    }
}
print OUTPUT "Finished cleaning up ATSFetchlet artifacts.\n";

#### Finished Cleaning Up ATSFetchlet artifacts ####

if ($ttl > 0) {
  $ttl = $ttl * 60;
} else {
  $ttl = 7 * 24 * 3600; 
}

print "em_result=1\n";

my @files = <$agentStateDir/sysman/emd/beaconLogs/*>;
my $now = time;


foreach $file (@files) {
  my $file_age = $now - stat($file)->mtime;

  if ($file_age > $ttl) {
    print OUTPUT "deleting $file\n";
    rmtree($file); 
  } else {
    print OUTPUT "keeping $file with $file_age\n";
  }
}

sub checkDirString {
  my $dirString = $_[0];
  if ( trimPath($dirString) eq '' ) {
    writeTestLog("'$dirString' is NOT alpha numeric.\n");
    return 0;
  } else {
    writeTestLog("'$dirString' is alpha numeric.\n");
    return 1;
  }
}

sub trimPath {
  my $dirString = $_[0];
  my $regEx = qr/^([\w]+)$/;
  my $result;
  if ( $dirString =~ $regEx ) {
      $result = $1;
  } else {
      $result = '';
  }
  return $result;
}

sub getPathKey {
  my @keys = @_;

  my $pathStr;
  if ( $#keys > -1) {
    my ($bcnId, $svcId, $txnId) = @keys;
    $pathStr = trimPath($bcnId) . '/' .
               trimPath($svcId) . '/' .
               trimPath($txnId);
  } else {
    $pathStr = '';
  }

  return $pathStr;
}

sub getFileKey {
  my (@keys) = @_;

  my $fileKey;
  if ( $#keys > -1) {
    my ($bcnId, $svcId, $txnId) = @keys;
    $fileKey = $txnId . '_' . $bcnId . ".zip";
  } else {
    $fileKey = '';
  }

  return $fileKey;
}

sub getDBFileKey {
  my (@keys) = @_;

  my $fileKey;
  if ( $#keys > -1) {
    my ($bcnId, $svcId, $txnId) = @keys;
    $fileKey = $txnId . '_' . $bcnId . "_db.zip";
  } else {
    $fileKey = '';
  }

  return $fileKey;
}

sub getIDKeys {
  my $file = $_[0];
  open (deleteFile, "$file");
  my $bcnId = <deleteFile>;
  my $svcId = <deleteFile>;
  my $txnId = <deleteFile>;
  close deleteFile;
  my $isValid = 0;
  if (checkDirString($bcnId) == 1 &&
      checkDirString($svcId) == 1 &&
      checkDirString($txnId) == 1) {
    $isValid = 1;
  } else {
    my $errorStr="$file does not contain valid keys\n";
    writeTestLog($errorStr);
    print OUTPUT $errorStr;
  }

  my @keys = ();
  if ($isValid == 1) {
    @keys = (trimPath($bcnId),
             trimPath($svcId),
             trimPath($txnId));
  }
  return @keys;
}

sub writeTestLog {
  my $str = @_[0];
  print TEST_OUTPUT $str if TEST_OUTPUT;
  print OUTPUT $str if OUTPUT;
}

sub canDelete {
  my ($deleteToken, $zipFile) = @_;
  my $deleteTime = stat($deleteToken)->mtime();
  my $zipTime    = stat($zipFile)->mtime();

  if ($deleteTime > $zipTime) {
    writeTestLog("$deleteToken is newer than zip $zipFile\n");
    return 1;
  } else {
    writeTestLog("zip $zipFile is newer than deletToken $deleteToken\n");
    return 0;
  }
}

sub localizeTime {
  my $seconds = $_[0];
  my $tm_obj = localtime($seconds);
  my $dateStr = sprintf "%4d-%02d-%02d %02d:%02d:%02d",
     $tm_obj->year()+1900,$tm_obj->mon()+1,$tm_obj->mday(),$tm_obj->hour(),$tm_obj->min(),$tm_obj->sec();
  return $dateStr;
}

close(OUTPUT);
close(TEST_OUTPUT);
