# $Header: emagent/sysman/admin/scripts/ccs/ecmCcsMain.pl /main/5 2011/03/24 11:16:31 skundalk Exp $
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    DESCRIPTION
#      Facade for the ccs scripts.
#
#    MODIFIED   (MM/DD/YY)
#       skundalk 03/07/11 - adding error printing method
#       skundalk 12/20/10 - getting target property string through STDIN
#       skundalk 10/05/10 - adding DB credential set changes
#       skundalk 09/09/10 - enable target property substitution code and
#                           updating script include path
#       skundalk 06/25/10 - ccs script files
#
##*********************************************************************
package ecmCcsMain;

require "ccs/ecmCcsUtils.pl";

#required script for getting credential object
require "emd_common.pl";

use strict;
use Env;
binmode STDOUT,":utf8";

my $THIS_FILE_NAME = "ecmCcsMain.pl";
my $localProperties = "LOCAL_PROPERTIES";


#==============================================================================
# logDebug(<message>)
#
# log the message to log file.
# Arguments:
#   message - message to be logged.
# Returns:
#   none
#==============================================================================
sub logDebug($) {
    ecmCcsUtils::logDebug($THIS_FILE_NAME, $_[0]);
    
    return;
}
    

#==============================================================================
# Main program.
#==============================================================================
logDebug("=================================================");

my $basePath = $ENV{'ECMCCSBASEPATH'};
my $ccsDef =  $ENV{'ECMCCSDEFINITION'};
my $dbUrl = $ENV{'ECMCCSDBURL'};
my $encoding = $ENV{'ECMCCSENCODING'};
my $dbCredPresent = $ENV{'ECMCCSDBCREDSET'};
# my $properties = $ARGV[0];

my $properties = "";

my $dbUser = "";
my $dbPassword = "";


logDebug("checking STDIN for target properties and db credential set.");
 
my %stdinvars =  get_stdinvars();

if (scalar(keys(%stdinvars)) > 0) {
   logDebug("getting target properties.");
   
   #get target property string through STDIN
   $properties = $stdinvars{"allprops"};

   logDebug("getting database credential set.");
   
   my $credType = getCredType("ccsdbcreds", \%stdinvars);
   my %credvars = getCredProps("ccsdbcreds", \%stdinvars);
  
   $dbUser = $credvars{"DBUserName"};
   $dbPassword = $credvars{"DBPassword"};
    
   logDebug("DB-CredType:".$credType);
}
else {
   logDebug("No data collected from STDIN.");
}


logDebug("basePath [$basePath], ccsDef [$ccsDef], encoding [$encoding], properties [$properties]");

logDebug("dbUrl [$dbUrl], dbUser [$dbUser], dbPassword [$dbPassword]");

eval {
   ecmCcsUtils::getData($basePath, $ccsDef, $encoding, $dbUrl, $dbUser, $dbPassword, $properties);
    
};

if ($@ ne "") {
        logDebug("FAILED: cause-, $@, $!");
        
        ecmCcsUtils::printError("$@");
}    
        
1;






















    
