# $Header: emagent/sysman/admin/scripts/ccs/ecmPropertyInstance.pl /main/3 2011/01/23 08:06:40 ysarig Exp $
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    DESCRIPTION
#      Seperate properties from a string representation of Target properties.
#
#    MODIFIED   (MM/DD/YY)
#       ysarig   01/19/11 - quoted strings should honor escapes that werre
#                           added
#       skundalk 09/09/10 - enable target property substitutio code and
#                           updating script include path
#       skundalk 06/25/10 - ccs script files
#      
##*********************************************************************
package ecmPropertyInstance;

require "ccs/ecmCcsUtils.pl";

use strict;

my $THIS_FILE_NAME = "ecmPropertyInstance.pl";
my $localProperties = "LOCAL_PROPERTIES";
my $data = "";
my $dataLength = 0;
my $index = 0;  
    
my %allPropertyMap = ();

#==============================================================================
# init()
#
# method to initialize all global local variables.
# Arguments:
#   none
# Returns:
#   none
#==============================================================================
sub initVariables() {
    $index = 0;
    %allPropertyMap = ();
}

#==============================================================================
# logDebug(<message>)
#
# log the message to log file.
# Arguments:
#   message - message to be logged.
# Returns:
#   none
#==============================================================================
sub logDebug($) {
    ecmCcsUtils::logDebug("ecmPropertyInstance.pl", $_[0]);
    
    return;
}
    
#==============================================================================
# <String:nextChar> nextChar()
#
# Get the next character after the current index. The method returns next 
# character from the string stored in variable $data.
#
# Arguments:
#   none
# Returns:
#  If the data index is less than the data length then next character will be returned.
# else a empty string will be returned. 
#==============================================================================
sub nextChar() {
    my $character = "";
    if ($index < $dataLength) {
        $character = substr($data, $index, 1);
        $index++;
    }
    
    return $character;
}



#==============================================================================
# getStringTill(<String:endChar>)
#
# Get the characters till the indicated character. The search character is not
# included in the return String.
# Note: if the character is not found the method dies.
#
# Arguments:
#   <String:endChar> - character to find and substring the data.
# Returns:
#   sub string till the end character.
#==============================================================================
sub getStringTill($) {
    my $endChar = $_[0];
    my $continue = 1;
    my $startIndex = $index;
    my $result = "";
    
     while (($index < $dataLength) && ($continue == 1)) {
         my $tempChar = nextChar();
         
         if ($tempChar eq "\\") {
            # escape character.
            nextChar();
        }    
        elsif ($tempChar eq $endChar) {
            $continue = 0;
            $result = substr($data, $startIndex, ($index - 1 - $startIndex));
        }    
     }
     
     if ($continue == 1) {
         logDebug("ERROR: Property data malformed. $endChar not found after $startIndex.");
         die "ERROR: Property data malformed. $endChar not found after $startIndex.";
     }
     else {
         logDebug("String $result collected till $index.");
     }
         
    return $result;
}    

#==============================================================================
# Main program.
#==============================================================================
logDebug("=================================================");
my %propertyMap; 

#==============================================================================
# <HashRef:propertyMap> processProperties(<String:data>)
#
# extract the properties from the string representation and store them in a Hash
# keyed by the targetType and value of the map containing another Hash where the
# key is property Name and value is the property value
# 
# Arguments:
#   <String:data> - data to be parsed for target properties.
# Returns:
#   Reference to a Hash-of-Hash
#==============================================================================
sub processProperties($) {
    initVariables();
    $data = $_[0];
    chomp($data);
    $dataLength = length($data);
    
    my $quote = 1;
    my $equal = 0;
    my $angelBracket = 1;
    my $comma = 0;
    
    
    my $propertyToken = 0;
    my $tmpStr = "";
    my $propertyName = "";
    my $propertyValue = "";
    my $targetType = $localProperties;
    my $propertyComplete = -1;
    
    while ($index < $dataLength) {
       my $tempChar = nextChar();
       
       if ($tempChar eq "\"" && $quote == 1) {
           $angelBracket = 0;
           
           $tmpStr = getStringTill("\"");
           $tmpStr =~ s/\\"/"/g;
           $tmpStr =~ s/\\\\/\\/g;
           
           if ($propertyToken == 0) {
               $propertyName = $tmpStr;
               $quote = 0;
               $equal = 1;
               $propertyToken++;
           }
           else {
               $propertyValue = $tmpStr;
               
               $quote = 0;
               $comma = 1;
               $propertyComplete = 1;
           }
       }
       elsif ($tempChar eq "=" && $equal == 1) {
           logDebug("equal found at $index");
           $equal = 0;
           $quote = 1;
       }
       elsif ($tempChar eq "," && $comma == 1) {
           logDebug("comma found at $index");
           $comma = 0;
           
           $quote = 1;
           $angelBracket = 1;
           $propertyComplete = 0;
           $propertyToken = 0;
           $targetType = $localProperties;
       }
       elsif ($tempChar eq "<" && $angelBracket == 1) {
           $angelBracket = 0;
           
           $targetType = getStringTill(">");
           
           $quote = 1;
       }
       else {
        logDebug("Invalid character $tempChar at index $index \n $data");
        die "ERROR:Invalid character $tempChar at index $index. Target property string malformed.\n";
       }
       
       if ($propertyComplete == 1) {
           my $refMap = $allPropertyMap{$targetType};
           
           if (defined($refMap) == 1) {
               $refMap->{$propertyName} = $propertyValue;
               my $dd = 1;
           } 
           else {
               my %map = ();
               $map{"$propertyName"} = $propertyValue;
               $allPropertyMap{$targetType} = \%map;
           }
           
       }
   }
   
   if ($propertyComplete == 0) {
      logDebug("Found incomplete property in data $data \n");
      die "ERROR:Found incomplete property in data $data \n"; 
   }
   
   return \%allPropertyMap;
}

1;






















    
