#!/bin/sh
#
# $Header: emagent/sysman/admin/scripts/checkCollectionOid.sh /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:16 pnayak Exp $
#
# checkCollectionOid.sh
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      checkCollectionOid.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#        usage: ckeckinfocollection.sh <oracleHome> <port#> [<hostName>]
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    achoudha    11/28/01 -
#    achoudha    11/28/01 -
#    achoudha    11/28/01 -
#    achoudha    11/27/01 -
#    achoudha    11/27/01 - Creation
#

LOGFILE=/tmp/oid$$.log

if [ $# -lt 2 ]
then
  echo "usage: ckeckinfocollection.sh <oracleHome> <port#> [<hostName>]" >> $LOGFILE 2>&1
  exit 1
fi

if [ $# -eq 3 ]
then
  hostName=$3
fi

oraHome=$1
portNo=$2

if [ $# -eq 3 ]
then
  $oraHome/bin/ldapsearch -h $hostName -p $portNo -b "" -s base "objectclass=*" orclstatsflag|grep orclstatsflag |cut -f2 -d = >> $LOGFILE 2>&1
else
  $oraHome/bin/ldapsearch -p $portNo -b "" -s base "objectclass=*" orclstatsflag|grep orclstatsflag |grep orclstatsflag |cut -f2 -d = >> $LOGFILE 2>&1
fi

cat $LOGFILE

exit 0

