#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/cluster_node_information.pl /st_emagent_10.2.0.1.0/3 2008/10/22 21:28:57 ajdsouza Exp $
#
# cluster_node_information.pl
# 
# Copyright (c) 2007, 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      cluster_node_information.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    12/07/07 - Creation
# 

use strict;
use warnings;
use Data::Dumper;
use File::Spec::Functions;
use File::Basename;
use File::Path;
#this module is not available in emagent 10.2.0.4
my $hostNameSub = 'hostOSD::getHostName';
my $hostDomainSub = 'hostOSD::getDomainName';
eval "use hostOSD; 1 " or undef $hostNameSub and undef $hostDomainSub
 and EMD_PERL_WARN("hostOSD perl module is not available");
use Sys::Hostname;
require "emd_common.pl";

my $emdRoot;

if ( $ENV{EMDROOT} )
{
 $emdRoot = $ENV{EMDROOT};
}
elsif ( $ENV{ORACLE_HOME} )
{
 $emdRoot = $ENV{ORACLE_HOME};
}

exit 1 unless $emdRoot;

my $cache_dir;
# build the path to the em state directory
$cache_dir =  catfile($emdRoot,'sysman');
$cache_dir =  catfile($cache_dir,'admin');
$cache_dir =  catfile($cache_dir,'scripts');
$cache_dir =  catfile($cache_dir,'has');
my $has_metrics_script =  catfile($cache_dir,'has_metrics.pl');

stat $has_metrics_script;

if ( $has_metrics_script and -e $has_metrics_script )
{
      $cache_dir =  catfile($emdRoot,'perl');
      $cache_dir =  catfile($cache_dir,'bin');
 
      my $perlexe;

      for my $pl ( ( 'perl', 'perl.exe', 'perl.bat' ) )
      {
        my $tmpdir = catfile($cache_dir,$pl);

        stat $tmpdir if $tmpdir;

        if ( $tmpdir and -e $tmpdir and -r $tmpdir )
        {
          $perlexe =  $tmpdir;
          last;
        }

      }
      
      if ( not $perlexe )
      {
        $perlexe = catfile($cache_dir,'perl');
      }


      my $results =
`$perlexe $has_metrics_script property nodename__clustername__crshome__nodelist__nodestatus`;

      my $nm;
      my $cn;
      my $ch;
      my $nl;
      my $ns;
      my @resarray = split /\n/,$results if $results;

      for my $row ( @resarray )
      {
         $row =~ s/\s+//;
         next unless $row;
         next unless $row =~ /^em_result=/;

         my ( $vals ) = ( $row =~ /^em_result=(.+)/);

         next unless $vals;
         #em_result=nm|cn|ch|nl|ns
         my @valarray = ( $vals =~ /^([^\|]*)\|([^\|]*)\|([^\|]*)\|([^\|]*)\|([^\|]*)/)
            if $vals =~ /^[^\|]*\|[^\|]*\|[^\|]*\|[^\|]*\|([^\|]*)/;

         next unless @valarray;
         next if @valarray < 5;

         $nm = $valarray[0] if defined $valarray[0];
         $cn = $valarray[1] if defined $valarray[1];
         $ch = $valarray[2] if defined $valarray[2];
         $nl = $valarray[3] if defined $valarray[3];
         $ns = $valarray[4] if defined $valarray[4];

         last;
      }

      if ( not $nm )
      {
         if ( $cn or $ch or $nl )
         {
           $nm = $ENV{SHORT_HOSTNAME} if $ENV{SHORT_HOSTNAME};

           #$nm = hostOSD::getHostName() unless $nm;
           #this module is not available in emagent 10.2.0.4
           #my $subOSDHost = "hostOSD::getHostName";
           #my $subref = \&$subOSDHost;

           if ( $hostNameSub and not $nm )
           {
             my $fnref = \&$hostNameSub;
             $nm =  &$fnref;
           }

           $nm = hostname unless $nm;
           $nm = $ENV{LONG_HOSTNAME} if $ENV{LONG_HOSTNAME} and not $nm;
           $nm = $ENV{HOST} if $ENV{HOST} and not $nm;
           $nm = $ENV{EM_TARGET_NAME} if $ENV{EM_TARGET_NAME} and not $nm;

           if ( not $nm )
           {
             print "em_error=Failed to get node name or host name for node\n";
             EMD_PERL_ERROR("WARN:cluster_node_information.pl:Failed to get node name or host name for node");
             exit 1;
           }
           else
           {
             chomp $nm;

             print "em_warning=Failed to get node name or host name for node\n";
             EMD_PERL_WARN("WARN:cluster_node_information.pl:Failed to get node name or host name for node");
           }
         }
      }


      if ( $nm )
      {
        $cn = '' unless $cn;
        $ch = '' unless $ch;
        $nl = '' unless $nl;
        $ns = '' unless $ns;

        print  "em_result=$nm|$cn|$ch|$nl|$ns\n";
      }

}


exit 0;
