#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/crs_vip.pl /st_emagent_10.2.0.1.0/2 2008/11/13 00:54:37 ajdsouza Exp $
#
# crs_vip.pl
# 
# Copyright (c) 2004, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      crs_vip.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    11/12/08 - Bug fix 7529426
#    ajdsouza    01/11/08 - Bug fix 6723959
#    hying       09/13/05 - alert on one node, clear on all 
#    hying       07/26/05 - 4518389, collect all vips on each node 
#    hying       01/10/05 - hying_crs_metrics
#    hying       12/30/04 - Creation
# 
require "emd_common.pl";
require "semd_common.pl";
                                                                                            

my $oldOH;

BEGIN
{

 use POSIX qw(locale_h);

 my $clocale='C';

 for ( qw ( LC_ALL LC_COLLATE LC_CTYPE LC_TIME LC_NUMERIC LC_MESSAGES LC_MONETARY LANG LANGUAGE ) )
 {
   $ENV{$_}=$clocale;
 }

 setlocale(LC_ALL,$clocale) or warn "WARN:Failed to set locale to $clocale \n ";

 # save ORACLE_HOME and restore it back in END
 $oldOH = $ENV{ORACLE_HOME} if $ENV{ORACLE_HOME};

 # temporarly setting environment only in dev view env
 # this code is not avtive in production
 # !! DO NOT CHANGE THE CLUSTER NAME HERE WHEN YOU
 # CHECK IN AS THIS WILL BREAK REGRESSION
 #
 # IF YOU ARE CREATING A HAS VIEW CREATE IT 
 # WITH VIEW NAME <sa view_name>t
 # e.g. if sa view is sa3114 the has view should be sa3114t
 # the clustername is the has view should be newdb_cluster
 if ( $ENV{ADE_VIEW_ROOT} )
 {
  my $advrt =  $ENV{ADE_VIEW_ROOT};
  $advrt  =~ s/_ag$//;
  $advrt  = $advrt."t";

  $ENV{ORA_CRS_HOME}="$advrt/oracle";
  $ENV{CSS_CLUSTERNAME}='newdb_cluster';

  $ENV{CRS_HOME}="$ENV{ORA_CRS_HOME}";
  $ENV{CV_HOME}="$ENV{CRS_HOME}";
  $ENV{OCR_ROOT}="$ENV{CRS_HOME}/has_work/data.ocr";
  $ENV{OCR_LOC}="$ENV{CRS_HOME}/has_work/ocr.loc";
  $ENV{OCR_DEVELOPER_ENV}='TRUE';
  $ENV{HAS_DEVELOPMENT_ENVIRONMENT}='TRUE';
  $ENV{CV_JDKHOME}="$ENV{CRS_HOME}/jdk15";
  $ENV{ORA_ENVIRON_OPTS}='true';

  my $libs = "$ENV{CRS_HOME}/lib:$ENV{CRS_HOME}/has/lib:$ENV{CRS_HOME}/opsm/lib";

  $ENV{LD_LIBRARY_PATH}="$libs:$ENV{LD_LIBRARY_PATH}" if $ENV{LD_LIBRARY_PATH};
  $ENV{LD_LIBRARY_PATH}="$libs" unless $ENV{LD_LIBRARY_PATH};

  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin:$ENV{PATH}" if $ENV{PATH};
  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin" unless $ENV{PATH};

 }

}


my $crs_home = shift(@ARGV); # CRSHome
if ($crs_home eq "")
{
  exit 0;
}
my $node_name = shift(@ARGV); # NodeName

#################################
# View testing required ENV
#$ENV{OCR_LOC} = "/etc/oracle/ocr.loc";
#$ENV{OCR_DEVELOPER_ENV}="true";
#$ENV{ORA_CRS_HOME} = $crs_home;
#$ENV{LD_LIBRARY_PATH} = "$crs_home/lib:$ENV{LD_LIBRARY_PATH}";
#################################
                                                                                            
my $cmd = "$crs_home/bin/crs_stat";
#bug fix 6723959
$ENV{ORACLE_HOME}=$crs_home;
my $result = `$cmd`;
                                                                                                                                
my @lines = split(/\n/, $result);
                                                                                                                                
my $i = 0;
my ($var, $val, $resource, $original_host, $current_host, $state, $on, $relocated);
                                                                                            
while ($i < $#lines)
{
  ($var, $val) = split(/=/, $lines[$i]);
  if ($var eq "NAME")
  {
    debug("Resource name: $val");
    $resource = $val;
    #bug fix 7529426
    if ($val =~ /ora\.(.+)\.vip$/)
    {
      $original_host = $1;
      while ($i < $#lines)
      {
        $i++;
        ($var, $val) = split(/=/, $lines[$i]);
        if ($var eq "STATE")
        {
          ($state, $on, $current_host) = split(/ /, $val);
          debug("Current host: $current_host");
          $relocated = ($original_host ne $current_host)? 'TRUE':'FALSE';
          if ($relocated eq 'TRUE' && $node_name eq $current_host)
          {
            printf "em_result=$resource|$relocated|$current_host\n";
            debug("em_result=$resource|$relocated|$current_host\n");
          }
          else
          {
            printf "em_result=$resource|FALSE|$current_host\n";
            debug("em_result=$resource|FALSE|$current_host\n");
          }
          last;
        }
      }
    }
  }
  $i++;
}
                                                                                            
sub debug
{
  my ($line) = @_;
  EMD_PERL_DEBUG("$line");
}
                                                                                            
exit 0

