#  $Header: emagent/sysman/admin/scripts/disk-busy.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:16 pnayak Exp $
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      disk-busy.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Disk busy percentage for all physical disks.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    NKJ: Only list non-nfs disks
#    Ash: Updated description for CGI index generation.
#    Ash: Updated to v0.5 of the spec.
#    Ash: Initial version.
#

$ENV{PATH} = "/usr/bin:/usr/sbin";

@DATA = `sar -d 5`;
@DATA = @DATA[5..$#DATA];

my $found = 0;

for (@DATA) {
  # Skip entries for nfs disks
  next if /\bnfs/;

  # Trim any leading time stamp.
  s/^\d+:\d+:\d+//;

  # Skip trailing blank line.
  next if /^\s*$/;

  # Gather the values.
  ($disk, $busy) = split;

  # Print the line and record that one was found.
#  print "em_result=$disk=$busy|Disk $disk is $busy% busy.\n";
  print "em_result=$disk=$busy\n";
  $found++;
}

if ($found == 0)
{
print "em_result= = \n";
}
