#  $Header: emagent/sysman/admin/scripts/disk-totio.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:16 pnayak Exp $
# 
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      disk-busy.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Disk IO's per second across all physical disks.
#      I/O's per second
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    gnl: Initial version. - lifted from disk-busy.pl
#


$ENV{PATH} = "/usr/bin:/usr/sbin";

@DATA = `sar -d 5`;

my $found = 0;
$totios =0;
$longest_serv = 0;

chomp ($os = `uname -s`) or die "Failed to run the uname command";
SWITCH: {
  $os eq "SunOS" && do {
                          chomp ($ver = `uname -r`);
                          if ( $ver !~ /^4./ ) {
                             $osType = "Sol";
                             last SWITCH;
                          }
                       };
  $os eq "HP-UX" && do {
                          $osType = "HP";
                          last SWITCH;
                       };
  die "Unupported Operating System\n";
}

if ($osType eq "Sol") {
# for Solaris
    @DATA = @DATA[5..$#DATA];
} else {
#for HP
    @DATA = @DATA[4..$#DATA];
}				


for (@DATA) {
  # Skip entries for nfs disks
  next if /\bnfs/;

  # Trim any leading time stamp.
  s/^\d+:\d+:\d+//;

  # Skip trailing blank line.
  next if /^\s*$/;

  # Gather the values splits the line into tokens I guess...
  ($disk, $busy, $avque, $rwsec, $blks, $avwait, $avser) = split;

  # keep running total if io/s per second
  $totios = $totios + $rwsec;

  if ($avser > $longest_serv)
    {
      $longest_serv = $avser;
    }

  $found++;
}

die "Unable to parse data\n" unless $found > 0;

print "em_result=$totios|$longest_serv\n";


