#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/ecmAssoc.pm /main/1 2011/05/05 10:36:31 glavash Exp $
#
# ecmAssoc.pm
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ecmAssoc - <one-line expansion of the name>
#
#    DESCRIPTION
#    This file contains the ECM Assocation strings, to be used by
#    all target types to describe their associations to other targets.
#    This file is used to ensure consistent naming of assocation types
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       02/01/11 - add Dogwood targets
#    proxy       06/12/10 - Adding IDM targets
#    nmittal     10/16/09 - XbranchMerge nmittal_bug-8943752 from
#                           st_emll_10.3.2
#    nmittal     10/13/09 - Adding weblogic_j2eeserver target type
#    nmittal     10/02/09 - XbranchMerge nmittal_bug-8629030 from
#                           st_emll_10.3.2
#    nmittal     09/18/09 - adding bea target type
#    rstorrie    06/22/09 - Addition of defined_by for collector based system
#                           generation
#    glavash     04/03/08 - add retail
#    aime        03/23/07 - 
#    ckannusa    01/30/07 - Add BI Target
#    ndutko      12/19/06 - JDEdwards E1 Integration
#    pparida     06/21/06 - Add target types oracle_ias_farm and 
#                           oracle_ias_cluster 
#    ndutko      08/03/05 - ndutko_code_checkin
#    dkapoor     06/24/05 - added rac_database
#    glavash     05/17/05 - creation
# 

use strict;

#*********************************
#  Global Variables
#*********************************

$ecmAssoc::CONNECTS_TO = 'connects_to';
$ecmAssoc::CONTAINS = 'contains';
$ecmAssoc::DEPENDS_ON = 'depends_on';
$ecmAssoc::DEFINED_BY = 'defined_by';
#
#HOSTED_BY is an implicit association.
#All targets are impliclity hosted_by the host where the collection
#script is run.  This assocation is represented in the ecm_live_link_targets
#table.  A target should only expose a HOSTED_BY assocation if the current host
#is not the Host that ultimately hosts the target.
# 
$ecmAssoc::HOSTED_BY = 'hosted_by';
$ecmAssoc::MEMBER_OF = 'member_of';
$ecmAssoc::MONITORED_BY = 'monitored_by';
$ecmAssoc::OPTIONALLY_CONNECTS_TO = 'optionally_connects_to';
$ecmAssoc::RELATES_TO = 'relates_to';
$ecmAssoc::REMOTELY_MONITORED_BY = 'remotely_monitored_by';
$ecmAssoc::RUNS_ON = 'runs_on';
$ecmAssoc::SERVICE_ACCESS_POINT = 'service_access_point';
#
# Target Types are listed here
#
#
$ecmAssoc::HOST_TYPE = 'host';
$ecmAssoc::LISTENER_TYPE = 'oracle_listener';
$ecmAssoc::NAMESERVER_TYPE = 'nameserver';
$ecmAssoc::OC4J_TYPE = 'oc4j';
$ecmAssoc::BEA_TYPE = 'bea';
$ecmAssoc::ORACLE_HOME_TYPE = 'oracle_home';
$ecmAssoc::ORACLE_APACHE_TYPE = 'oracle_apache';
$ecmAssoc::ORACLE_APACHE_CLUSTER_TYPE = 'oracle_apache_cluster';
$ecmAssoc::ORACLE_APPLICATION_TYPE = 'oracle_application';
$ecmAssoc::ORACLE_APPS_DB_TYPE = 'oracle_apps_db';
$ecmAssoc::ORACLE_APPS_INF_TYPE = 'oracle_apps_inf';
$ecmAssoc::ORACLE_APPS_SYSTEM = 'oracle_apps_system';
$ecmAssoc::ORACLE_BEACON_TYPE = 'oracle_beacon';
$ecmAssoc::ORACLE_CSA_COLLECTOR_TYPE = 'oracle_csa_collector';
$ecmAssoc::ORACLE_DATABASE_TYPE = 'oracle_database';
$ecmAssoc::ORACLE_EMD_TYPE = 'oracle_emd';
$ecmAssoc::ORACLE_EMREP_TYPE = 'oracle_emrep';
$ecmAssoc::ORACLE_JSERV_TYPE = 'oracle_jserv';
$ecmAssoc::ORACLE_LDAP_TYPE = 'oracle_ldap';
$ecmAssoc::ORACLE_IAS_TYPE = 'oracle_ias';
$ecmAssoc::ORACLE_OCSV2_TYPE = 'oracle_ocsv2';
$ecmAssoc::ORACLE_OVF_TYPE = 'oracle_ovf';
$ecmAssoc::ORACLE_PORTAL_TYPE = 'oracle_portal';
$ecmAssoc::ORACLE_WEBCACHE_TYPE = 'oracle_webcache';
$ecmAssoc::ORACLE_WIRELESS_TYPE = 'oracle_wireless';
$ecmAssoc::ORACLE_SSO_SERVER_TYPE = 'oracle_sso_server';
$ecmAssoc::RAC_DATABASE_TYPE = 'rac_database';
$ecmAssoc::ASM_INSTANCE_TYPE = 'osm_instance';
$ecmAssoc::ORACLE_IAS_FARM_TYPE = 'oracle_ias_farm';
$ecmAssoc::ORACLE_IAS_CLUSTER_TYPE = 'oracle_ias_cluster';
$ecmAssoc::ORACLE_WEBLOGIC_SERVER = 'weblogic_j2eeserver';
$ecmAssoc::WEBLOGIC_DOMAIN = 'weblogic_domain';

#
# Identity and Access Management Types are listed here
#
$ecmAssoc::ORACLE_IDM_TYPE = 'oracle_idm';
$ecmAssoc::ORACLE_IAM_INSTANCE = 'oracle_iam_instance';
$ecmAssoc::ORACLE_EPS_SERVER = 'oracle_eps_server';
$ecmAssoc::ORACLE_OVD = 'oracle_ovd';
$ecmAssoc::ORACLE_FEDERATTION = 'oracle_federation';
$ecmAssoc::ORACLE_OAAM = 'oracle_oaam';
$ecmAssoc::ORACLE_OAM = 'oracle_oam';
$ecmAssoc::ORACLE_OIM = 'oracle_oim';

#
# PeopleSoft Target Types are listed here
#
$ecmAssoc::PSFT_APP_SERVER = 'oracle_psft_appsrv';
$ecmAssoc::PSFT_BAT_SERVER = 'oracle_psft_batsrv';
$ecmAssoc::PSFT_DATABASE = 'oracle_psft_database';
$ecmAssoc::PSFT_WEB_SERVER = 'oracle_psft_websrv';

#
# Siebel Target Types are listed here
#
$ecmAssoc::SIEBEL_ENTERPRISE= 'siebel_enterprise';
$ecmAssoc::SIEBEL_SERVER= 'siebel_server';
$ecmAssoc::SIEBEL_COMPONENT= 'siebel_component';
$ecmAssoc::SIEBEL_COMPGROUP= 'siebel_component_group';
$ecmAssoc::SIEBEL_GATEWAY= 'siebel_gateway';


#
# EnterpriseOne Target Types are listed here
#
$ecmAssoc::ORACLE_E1_CONFIG_TYPE = 'oracle_e1_config';
$ecmAssoc::ORACLE_E1_SCF_MC_TYPE = 'oracle_e1_scf_mc';
$ecmAssoc::ORACLE_E1_SCF_SA_TYPE = 'oracle_e1_scf_sa';
$ecmAssoc::ORACLE_E1_SCF_SA_WEBSERVER_TYPE = 'oracle_e1_scf_sa_webserver';
$ecmAssoc::ORACLE_E1_SCF_SA_ENTSERVER_TYPE = 'oracle_e1_scf_sa_entserver';
$ecmAssoc::ORACLE_E1_SCF_SA_PIMSYNCH_TYPE = 'oracle_e1_scf_sa_pimsynch';
$ecmAssoc::ORACLE_E1_SCF_SA_RTESERVER_TYPE = 'oracle_e1_scf_sa_rteserver';
$ecmAssoc::ORACLE_E1_SCF_SA_COLLABPORTAL_TYPE = 'oracle_e1_scf_sa_collabportal';

#
#BI Target Types are listed here
#
$ecmAssoc::ORACLE_BI_ANS = 'oracle_bi_ans';
$ecmAssoc::ORACLE_BI_CC = 'oracle_bi_cc';
$ecmAssoc::ORACLE_BI_PS = 'oracle_bi_ps';
$ecmAssoc::ORACLE_BI_SCH = 'oracle_bi_sch';
$ecmAssoc::ORACLE_BI_DAC = 'oracle_bi_dac';
$ecmAssoc::ORACLE_BI_WEB = 'oracle_bi_web';
#
# Retail Target Types are listed here
#
$ecmAssoc::ORACLE_RETAIL_RSM_TYPE = 'oracle_retail_rsm';
$ecmAssoc::ORACLE_RETAIL_RMS_TYPE = 'oracle_retail_rms';
$ecmAssoc::ORACLE_RETAIL_ALLOC_TYPE = 'oracle_retail_AllocApp';
$ecmAssoc::ORACLE_RETAIL_REIMAPP_TYPE = 'oracle_retail_ReIMApp';
$ecmAssoc::ORACLE_RETAIL_RIBJAVAEEAPP_TYPE = "oracle_retail_RibJavaEEApp";
$ecmAssoc::ORACLE_RETAIL_RPM_TYPE = "oracle_retail_RPMApp";
$ecmAssoc::ORACLE_RETAIL_SIM_TYPE = 'oracle_retail_SIMApp';
$ecmAssoc::ORACLE_RETAIL_BO_JAVAEEAPP_TYPE = "oracle_retail_BO_JavaEEApp";
$ecmAssoc::ORACLE_RETAIL_CO_JAVAEEAPP_TYPE = "oracle_retail_CO_JavaEEApp";
$ecmAssoc::ORACLE_RETAIL_RM_JAVAEEAPP_TYPE = "oracle_retail_RM_JavaEEApp";
$ecmAssoc::ORACLE_RETAIL_RPAS_SERVER = 'oracle_retail_RpasServerApp';
$ecmAssoc::ORACLE_RETAIL_RPAS_SIMPLE_DOMAIN = 'oracle_retail_RpasSimpleDomain';
$ecmAssoc::ORACLE_RETAIL_RPAS_GLOBAL_DOMAIN = 'oracle_retail_RpasGlobalDomain';
$ecmAssoc::ORACLE_RETAIL_RPAS_SUB_DOMAIN = 'oracle_retail_RpasSubDomain';
$ecmAssoc::ORACLE_RETAIL_RWMS_TYPE = "oracle_retail_RWMSApp";
$ecmAssoc::ORACLE_RETAIL_ARI_TYPE = "oracle_retail_ARIApp";
$ecmAssoc::ORACLE_RETAIL_RDW_TYPE = "oracle_retail_RDW";
$ecmAssoc::ORACLE_RETAIL_ORW_TYPE = 'oracle_retail_ORWApp';
#
# Beehive Target Types are listed here
#
$ecmAssoc::BEEHIVE_SITE_TYPE = 'beehive_site';
$ecmAssoc::BEEHIVE_CALDAVAPP_TYPE = 'beehive_caldavapp';
$ecmAssoc::BEEHIVE_CALDAVINST_TYPE = 'beehive_caldavinst';
$ecmAssoc::BEEHIVE_CONFERENCEAPP_TYPE = 'beehive_conferenceapp';
$ecmAssoc::BEEHIVE_CONFERENCEINST_TYPE = 'beehive_conferenceinst';
$ecmAssoc::BEEHIVE_DEVICEMGMTAPP_TYPE = 'beehive_devicemgmtapp';
$ecmAssoc::BEEHIVE_DEVICEMGMINST_TYPE = 'beehive_devicemgmtinst';
$ecmAssoc::BEEHIVE_DISCUSSIONSAPP_TYPE = 'beehive_discussionsapp';
$ecmAssoc::BEEHIVE_DISCUSSIONSINST_TYPE = 'beehive_discussionsinst';
$ecmAssoc::BEEHIVE_EMAILAPP_TYPE = 'beehive_emailapp';
$ecmAssoc::BEEHIVE_EMAILINST_TYPE = 'beehive_emailinst';
$ecmAssoc::BEEHIVE_FTPAPP_TYPE = 'beehive_ftpapp';
$ecmAssoc::BEEHIVE_FTPINST_TYPE = 'beehive_ftpinst';
$ecmAssoc::BEEHIVE_IMAPP_TYPE = 'beehive_imapp';
$ecmAssoc::BEEHIVE_IMINST_TYPE = 'beehive_iminst';
$ecmAssoc::BEEHIVE_PRESENCEAPP_TYPE = 'beehive_presenceapp';
$ecmAssoc::BEEHIVE_PRESENCEINST_TYPE = 'beehive_presenceinst';
$ecmAssoc::BEEHIVE_PUSHMAILAPP_TYPE = 'beehive_pushmailapp';
$ecmAssoc::BEEHIVE_PUSHMAILINST_TYPE = 'beehive_pushmailinst';
$ecmAssoc::BEEHIVE_SEARCHAPP_TYPE = 'beehive_searchapp';
$ecmAssoc::BEEHIVE_SEARCHINST_TYPE = 'beehive_searchinst';
$ecmAssoc::BEEHIVE_TIMEMGMTAPP_TYPE = 'beehive_timemgmtapp';
$ecmAssoc::BEEHIVE_TIMEMGMTINST_TYPE = 'beehive_timemgmtinst';
$ecmAssoc::BEEHIVE_USERDIRECTORYAPP_TYPE = 'beehive_userdirectoryapp';
$ecmAssoc::BEEHIVE_USERDIRECTORYINST_TYPE = 'beehive_userdirectoryinst';
$ecmAssoc::BEEHIVE_VOICEMESSAGEAPP_TYPE = 'beehive_voicemessageapp';
$ecmAssoc::BEEHIVE_VOICEMESSAGEINST_TYPE = 'beehive_voicemessageinst';
$ecmAssoc::BEEHIVE_WEBDAVAPP_TYPE = 'beehive_webdavapp';
$ecmAssoc::BEEHIVE_WEBDAVINST_TYPE = 'beehive_webdavinst';
$ecmAssoc::BEEHIVE_WORKSPACESAPP_TYPE = 'beehive_workspacesapp';
$ecmAssoc::BEEHIVE_WORKSPACESINST_TYPE = 'beehive_workspacesinst';
$ecmAssoc::BEEHIVE_XMPPAPP_TYPE = 'beehive_xmppapp';
$ecmAssoc::BEEHIVE_XMPPINST_TYPE = 'beehive_xmppinst';
