# $Header: emagent/sysman/admin/scripts/emdConfiguration.pl /main/1 2011/04/05 19:04:37 tsubrama Exp $
#
# Package : emdConfiguration.pl
#
# Copyright (c) 2002, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#     emdConfiguration.pl 
#
#   DESCRIPTION
#       Collects the agent configuration information
#
#   returns EM_RESULT =
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#     tsubrama   02/15/11 - fix for model convergence
#     rstorrie   12/09/10 - Change the location of JAVA to ORACLE_HOME rather
#                           than CONFIG_HOME
#     rstorrie   05/18/10 - Add config home as a collected value
#     rstorrie   03/22/10 - The mapping for the PERL parameters is wrong
#     bkchoudh   03/18/10 - Fixed Bug 9463248,changed exe to bat, called callEmctl
#     rstorrie   03/09/10 - Bug 8984993 Make use of new generic callEmctl
#                           routine
#     raankire   02/12/10 - Change of collectConfig sub, added secure_status
#     rstorrie   09/18/09 - Fix java version on windows by adding .exe to the
#                           file extension
#     raankire   06/04/09 - Change of collectJava sub, Added Java Version
#     rstorrie   11/23/05 - Change of PERCENT_FLOOR 
#     rstorrie   11/22/05 - Creation
##*************************************************************

use strict;
use File::Spec;
use Switch;
use Config;

require "emd_common_ocm.pl";

my $agentConfigRoot = shift;
my $ll_oracle_home = shift;
my $collectionType = shift;

$ENV{LL_ORACLE_HOME} = $ll_oracle_home;

# Setup a reference table for all the valid parameters. This allows us to check if 
# the parameter is one we wish to collect.    
my $refPropertyMap = {    'EMD_URL' => 'EMD_URL',
                          'Agent_Version' => 'VERSION',
                          'REPOSITORY_URL' => 'REPOSITORY_URL',
                          'agentTZRegion' => 'agentTZRegion',
                          'UploadInterval' => 'UPLOAD_INT',
                          'UploadFailBackoffPct' => 'UPLOAD_BACKOFF_PERCENT',
                          'UploadTimeout' => 'UPLOAD_TIMEOUT',
                          'UploadMaxTime' => 'UPLOAD_MAXTIME',
                          'UploadFileSize' => 'UPLOAD_FILE_SIZE',
                          'UploadMaxBytesXML' => 'UPLOAD_MAX_BYTES_XML',
                          'UploadMaxNumberXML' => 'UPLOAD_MAX_NUMBER_XML',
                          'UploadMaxDiskUsedPct' => 'UPLOAD_MAX_DISK_USED_PERCENT',
                          'UpUploadMaxDiskUsedPctFloor' => 'UPLOAD_MAX_DISK_USED_FLOOR',
                          'DbHangTimeout' => 'DB_HANG_TIMEOUT',
                          'AgentListenOnAllNICs' => 'AgentListenOnAllNICs',
                          'emdFailureScript' => 'FAILURE_SCRIPT',
                          'emd_email_address' => 'EMAIL_ADDRESS',
                          'emd_email_gateway' => 'EMAIL_GATEWAY',
                          'emd_from_email_address' => 'EMAIL_FROM_ADDRESS',
                          'SECURE_STATUS' => 'SECURE_STATUS',
                          'NormalThreadStackSize' => 'NORMAL_THREAD_STACK',
                          'ThreadPoolModel' => 'THREAD_POOL_MODEL',
                          'IgnoreSignals' => 'IGNORE_SIGNALS',
                          'enableMetricBrowser' => 'METRIC_BROWSER',
                          'disableRemoteOperations' => 'DISABLE_REMOTE_OPERATIONS',
                          'RemoteAPITimeout' => 'REMOTE_API_TIMEOUT',
                          'altAdminPath' => 'ALT_ADMIN_PATH',
                          'MaxHealthMonitorThreads' => 'MAX_HEALTH_MONITOR_THREADS',
                          'SSLSessionCache' => 'SSL_SESSION_CACHE',
                          'httpTimeoutPrimaryHeader' => 'HTTP_PRIMARY_TIMEOUT',
                          'httpTimeoutSecondaryHeaders' => 'HTTP_SECONDARY_TIMEOUT',
                          'httpTimeoutBody' => 'HTTP_BODY_TIMEOUT',
                          'dynamicPropsComputeTimeout' => 'DYNAMIC_PROP_TIMEOUT',
                          'dynamicPropsComputeTimeout_rac_database' => 'DYNAMIC_RAC_TIMEOUT',
                          'dynamicPropsComputeTimeout_oracle_database' => 'DYNAMIC_DB_TIMEOUT',
                          'OMS_VERSION' => 'OMS_VERSION',
                          'OMS_CHARSET' => 'OMS_CHARSET',
                          'OMS_PROTOCOL_VERSION' => 'OMS_PROTOCOL_VERSION',
                          'JAVA_HOME' => 'JAVA_HOME',
                          'CLASSPATH' => 'CLASSPATH',
                          'hostConfigClasspath' => 'HOST_CLASSPATH',
                          'JAVA_OPTIONS' => 'JAVA_OPTIONS',
                          'agentJavaDefines' => 'AGENT_DEFINES',
                          'perlBin' => 'PERL_BIN',
                          'EMAGENT_PERL_TRACE_LEVEL' => 'PERL_TRACE_LEVEL',
                          'EMAGENT_PERL_TRACE_DIR' => 'PERL_TRACE_DIR',
                          'EMAGENT_PERL_TRACE_SIZE' => 'PERL_TRACE_SIZE',
                          'LogFileWithPID' => 'LOG_FILE_PID',
                          'LogFileMaxSize' => 'LOG_FILE_MAX_SIZE',
                          'LogFileMaxRolls' => 'LOG_FILE_MAX_ROLLS',
                          'TrcFileMaxSize' => 'TRACE_FILE_MAX_SIZE',
                          'TrcFileMaxRolls' => 'TRACE_FILE_MAX_ROLLS'};
    
SWITCH:
{
    $collectionType eq "config" && do 
    {
        collectConfig();
    	last SWITCH;
    };
    $collectionType eq "java" && do
    {
    	collectJava();
    	last SWITCH;
    };
    die "No valid parameter supplied, exiting\n";
}



# Procedure to collect all the configuration parameters
sub collectConfig()
{
    my %configParams;        
    my $property;
    
    # Need emd.properties to assign the configuration parameters
    my $emd_properties_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "emd.properties" );
    # Need protocol.ini for the protocol versions
    my $protocol_ini_file = File::Spec->catfile( $agentConfigRoot, "sysman", "emd", "protocol.ini" );

    if (-f $emd_properties_file)
    {
        open (FILE, "<$emd_properties_file") or EMD_PERL_DEBUG("Unable to open $! \n",$emd_properties_file);
        my $line; 
       
        #Scan through the file assigning the various parameters to get the values
        while ($line = <FILE>)
        {
    	    chomp $line;           
            if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $configParams{"$property"}=$2;
                }
            }
        }
        close FILE;
    }
    if  (-f $protocol_ini_file)  
    {
        # Now parse the protocol.ini to get that
        open (FILE, "<$protocol_ini_file") or EMD_PERL_DEBUG("Unable to open $! \n",$protocol_ini_file);
        my $line;
        while ($line = <FILE>)
        {
    	    chomp $line;
    	    if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $configParams{"$property"}=$2;
                }
            }
        }
        close FILE;
    }
    my @agentVersion = callEmctl("getversion");
    my $versionString;
    my $version='';
    foreach $versionString (@agentVersion)
    {
        chomp ($versionString);
        if ($versionString =~ /Agent Version ([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/)
        {
                $version = $1;
                last;
        }
    }

##Added for secure_status
                my $i;
                my $line_str;
                my $secure_found;
                my $unsecure_found;
                my $secure_search="agent is secure";
                my $unsecure_search="agent is unsecure";
                my @output_agent_sec;
                @output_agent_sec = callEmctl("status agent -secure");

                EMD_PERL_DEBUG("For emctl agent secure command, Please see the following output");

                foreach $i (0..($#output_agent_sec)) 
                {
                   $line_str=$output_agent_sec[$i];
                   EMD_PERL_DEBUG("$line_str \n");
                   $line_str=lc($line_str);
                   $secure_found=rindex $line_str,$secure_search;
                   if ($secure_found >= 0) 
                   {
                       $configParams{"SECURE_STATUS"}=$output_agent_sec[$i];
                   }
                   if ($secure_found == -1) 
                   {
                      $unsecure_found=rindex $line_str,$unsecure_search;
                      if ($unsecure_found >= 0) 
                      {
                         $configParams{"SECURE_STATUS"}=$output_agent_sec[$i];
                      }
                  }
                }
 # remove the CR from the agent output
 chomp $configParams{"SECURE_STATUS"} if(defined($configParams{"SECURE_STATUS"}));
##End of secure_status

    # Print the results of the configuration parameters
    print "em_result=" . $configParams{"EMD_URL"} . "|" 
                       . $version . "|"
                       . $configParams{"REPOSITORY_URL"} . "|"
                       . $configParams{"agentTZRegion"} . "|"
                       . $configParams{"AgentListenOnAllNICs"} . "|"
                       . $configParams{"OMS_VERSION"}. "|"
                       . $configParams{"OMS_CHARSET"} . "|"
                       . $configParams{"OMS_PROTOCOL_VERSION"}. "|"
		       . $configParams{"SECURE_STATUS"}. "\n";
}

# Procedure to collect Java parameters
sub collectJava()
{
    my %javaParams;
    my $property;
    my @java_version;
	
    # Need emd.properties to assign the java parameters
    my $emd_properties_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "emd.properties" );

    #Need java file to check the java version 
    my $java_jre_file = File::Spec->catfile( $ll_oracle_home,"jdk", "jre","bin","java" );
    my $java_jdk_file = File::Spec->catfile( $ll_oracle_home,"jdk","bin","java" );
  
    if (-f $emd_properties_file)
    {
        open (FILE, "<$emd_properties_file") or EMD_PERL_DEBUG("Unable to open $! \n",$emd_properties_file);
        my $line;
        while ($line = <FILE>)
        {
    	    chomp $line;
    	    if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $javaParams{"$property"}=$2;
                }
            }    	                            
        }
        close FILE;
    }
    #Get the Java Version
    if ((-f $java_jre_file) || (-f $java_jre_file.".exe"))
    {
	my $java_version_out = `$java_jre_file -version 2>&1` or EMD_PERL_DEBUG("Unable to execute JAVA VERSION : $! \n",$java_jre_file);
	@java_version = split(/"/, $java_version_out);
    }
    elsif ((-f $java_jdk_file) || (-f $java_jdk_file.".exe"))
    {
	my $java_version_out = `$java_jdk_file -version 2>&1` or EMD_PERL_DEBUG("Unable to execute JAVA VERSION : $! \n",$java_jdk_file);
        @java_version = split(/"/, $java_version_out);
    }	
 
    # Print the results of the java parameters
    print "em_result=" . $javaParams{"JAVA_HOME"} . "|"
		       . $javaParams{"AGENT_DEFINES"} . "|" 
		       . $java_version[1] . "\n";
}

# Routine for executing emctl, on Win32 this involves calling emctl.pl #####
# The routine is currently used by discvoery for getemhome ######
# and emd configuration for getversion ######

sub callEmctl
{
    my ($emctlParam) = @_;

    # Get the CONSOLE_CFG property from emctl, if emctl does not exist exit
    my $emctl_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "bin", "emctl");
    my $emctl_perl = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "bin", "emctl.pl");
    # If we are on windows then get emctl.bat rather than emctl
    my $OSNAME = $Config{'osname'};
    my $IsWin32 = ($OSNAME eq 'MSWin32');
    my $hsoe = "";

    if($IsWin32)
    {
        $emctl_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "bin", "emctl.bat" );
        open (EMCTLFILE, $emctl_file) or return '';
        my $line;

        while ($line = <EMCTLFILE>)
        {
           chomp $line;
           if ( $line =~ /^\s*set HOST_SID_OFFSET_ENABLED\s*=\s*(.*?)$/)
           {
              $hsoe = $1;
           }
        }
        close EMCTLFILE;
    }

    my $agent_only_install=0;
    if (-f $emctl_file)
    {
        open (EMCTLFILE, $emctl_file) or return '';
        # Check if CONSOLE_CFG is set to agent
        my @emctlData=<EMCTLFILE>;
        close EMCTLFILE;
        foreach (@emctlData)
        {
            if ((/^\s*CONSOLE_CFG\s*=\s*agent\s*$/) || (/^\s*set CONSOLE_CFG\s*=\s*agent\s*$/))
            {
                $agent_only_install=1;
                last;
            }
        }
    }

    # If we didnt find CONSOLE_CFG set to agent then exit
    # Currently this script is designed for grid control agents
    if ( $agent_only_install == 0 )
    {
        return '';
    }

    my @getemctl_output;

    # Use the emctl command to ?hsoeget the true home of the agent
    # This may not be ORACLE_HOME for dbconsole or RAC installs
    # On Windows this was found not to be possible
    # Therefore a direct call is made to emctl.pl to get the home

    if($IsWin32)
    {
        $ENV{EMDROOT}="$ENV{LL_ORACLE_HOME}";
        $ENV{CONSOLE_CFG}="agent";
        $ENV{PERL5LIB}="$ENV{PERL5LIB};$ENV{LL_ORACLE_HOME}/bin";
        $ENV{ORACLE_HOME}="$ENV{LL_ORACLE_HOME}";
        $ENV{JAVA_HOME}="$ENV{LL_ORACLE_HOME}/jdk";
        $ENV{HOST_OFFSET_ENABLED}=$hsoe;
        @getemctl_output= `$^X $emctl_perl $emctlParam`;
    }
    else
    {
        @getemctl_output= `$emctl_file $emctlParam`;
    }
    return @getemctl_output;
}

