#  $Header: emagent/sysman/admin/scripts/emd_common.pl /main/38 2012/03/09 17:36:31 jashukla Exp $
#
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emd_common.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file contains common subroutines.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#      rramaiah  12/22/11 - Bug 12793062: Include platform specific LIBPATH
#      glavash   03/29/11 - conditionally require emd_dbcommon.pl
#      nigandhi  03/01/11 - check if user perl tracing is requested
#      njagathe  07/01/10 - Handle values with = at end
#      njagathe  05/11/10 - Adding getCredObj
#      jaysmith  04/14/10 - emd.properties from emstate, not emhome
#      tpalgudi  11/12/09 - Bug#4067458 fix - Uninitialized value in
#                           concatenation warning
#      kganapat  05/08/09 - XbranchMerge kganapat_fix_8434736 from
#                           st_emagent_10.2.0.5.3as11
#      danili    01/05/09 - Backport danili_bug-7685399 from main
#      danili    12/09/08 - Remove Oraperl dependency unless LD_LIBRARY_PATH is
#                           set
#      tpalgudi  11/13/08 - Bug#4067458 fix
#      njagathe  07/04/08 - 
#      qding     05/08/08 - XbranchMerge qding_bug-5334573 from main
#      qding     05/06/08 - perl trace file size in MB
#      apenmets  02/21/08 - Adding New Output Property for JDBCSQLFetchlet
#      kganapat  11/19/07 - XbranchMerge kganapat_proj-16219 from main
#      mgoodric  09/03/07 - fix perl warnings
#      apenmets  08/28/07 - removing emd.properties dependecny from execute_jdbc_sql
#      kganapat  06/14/07 - Use EMSTATE instead of ORACLE_HOME
#      apenmets  06/06/07 - Adding execute_jdbc_sql
#      nigandhi  03/09/07 - Fix bug 5924743
#      nigandhi  08/10/07 - Backport nigandhi_bug-5924743 from main
#      mkiran    03/19/07 - 5682538: Handle multiple '='s in <name>=<val> strs
#      kganapat  11/23/06 - Add filterOraError subroutine
#      kganapat  09/11/06 - Add modifyProperty subroutine
#      kduvvuri  08/25/04 - fix bug 3848591. 
#      jsutton   04/15/04 - Clean up warnings 
#      kduvvuri  10/28/03 - use EMSTATE instead of AGENTSTATE as the dir for 
#                           perl tracing.(b3221051) 
#      jsoule    08/29/03 - fix non-existant procedure call 
#      xxu       03/05/03 - add EMAGENT_isPerl*Enabled check
#      vnukal    12/16/02 - making trace directory state-only install aware
#      pbantis   12/07/02 - Fix agent tracing
#      xxu       11/25/02 - do not fail if cannot write to trace file
#      xxu       11/04/02 - EMD->EMAGENT
#      xxu       10/24/02 - add more tracing levels
#      xxu       06/25/02 - remove /usr/local/bin/perl
#      aaitghez  08/07/01 - filename issues.
#      aaitghez  08/05/01 - adding dbms_application registration function.
#      xxu       07/31/01 - add trace support
#      xxu       05/29/01 - move system dependent code into semd_common.pl
#      xxu       05/21/01 - cut over from tcl
#      xxu       05/21/01 - Creation
# 
#

use strict;
use FileHandle;
use File::Basename;
require "find_os.pl";


# Returns the name of the shared library path environment variable
# for the current platform
sub get_shared_lib_path_name
{
    my $lib_path_name = "";
    my $osType = get_osType();

    if ( $osType eq "SOL" ||
         $osType eq "LNX" ||
         $osType eq "OSF1" ) {
        $lib_path_name = 'LD_LIBRARY_PATH' ;
    } elsif ( $osType eq "HP" ) {
        $lib_path_name = 'SHLIB_PATH' ;
        delete $ENV{LD_LIBRARY_PATH};
    } elsif ( $osType eq "AIX" ) { 
        $lib_path_name = 'LIBPATH' ;
    } elsif ( $osType eq "MAC OS X" ) {
        $lib_path_name = 'DYLD_LIBRARY_PATH' ;
    }

    return( $lib_path_name );
}


# We guard against sudo stripping LD_LIBRARY_PATH from the environment, which 
# causes dynamic library loading to fail when perl compiles the Oraperl module.
# At least for sudo, all "LD_*" enviroment variables are stripped first, so we
# don't have to worry about different platforms's run-time library path variables.
#do not require if this is an OCM collector
my $lib_path_name = get_shared_lib_path_name;

if ( !defined $ENV{CCR_HOME} && defined $ENV{$lib_path_name} || ($^O eq "MSWin32") || ($^O eq "Windows_NT") )
{
  require "emd_dbcommon.pl";
}

my $EMAGENT_PERL_TRACE_LEVEL_DEBUG  = 1;
my $EMAGENT_PERL_TRACE_LEVEL_INFO   = 2;
my $EMAGENT_PERL_TRACE_LEVEL_WARN   = 3;
my $EMAGENT_PERL_TRACE_LEVEL_ERROR  = 4;
# parses <STDIN> 
# reads any line of thge form <name>=<var>
# and returns a string of the form: "$<name>=<value>;$<name>=<value>;"
sub get_stdinvars
{
    my %r;
    while(<STDIN>)
    {
        # 5682538: Trim white spaces (newline) at end-of-line
        $_ =~ s/\s+$//;

        # 5682538: Handle <val> of <nam>=<val> with '=' characters
        # Ex: EM_TARGET_PASSWORD=db=snmp
        # Split and join does not work if value has a trailing =
        # Use index and substr instead
        my $eqpos = index($_, "=");
        my $nam = substr($_, 0, $eqpos);
        my $val = substr($_, $eqpos+1);

            if($val eq "__BeginProp__")
            {
        while(<STDIN>)
        {
          if($_ ne "__EndProp__\n")
          {
            $r{"$nam"} .= "$_";
          }
          else { last; }
        }
      }
      else
      {
        $r{"$nam"} = "$val"; 
      }

    }
    return %r;
}

# This subroutine picks up the credential type for a credential 
# from the stdin args properties
sub getCredType
{
    my $credName = $_[0];
    my %propHash = %{$_[1]};
    
    my $value = $propHash{"Cred_" . $credName . "_Type"};
    return $value;
}


# This subroutine picks up the properties for a particular credential 
# from the stdin args properties
sub getCredProps
{
    my $credName = $_[0];
    my %propHash = %{$_[1]};
    my %credProps = {};

    my $credPropPrefix = "^Cred_" . $credName . ":";
    my $credPrefixLen = length($credPropPrefix) - 1;
    
    my $key = "";
    foreach $key (keys %propHash) {
        if ($key =~ $credPropPrefix) {
            my $propName = substr($key, $credPrefixLen);
            $credProps{$propName} = $propHash{$key};
        }
    }    
    return %credProps;
}

# This subroutine has been introduced because get_stdinvars keeps
# waiting on <STDIN> on NT.End line character on the caller is not working on NT
# Caller needs to write "__*END*_\n" as last entry in the stdin to exit
sub get_stdinvars_with_end_line
{
    my %r;
    while(<STDIN>)
    {
        # 5682538: Trim white spaces (newline) at end-of-line
        $_ =~ s/\s+$//;

        if($_ eq "__*END*__")
        {
            goto exiting;
        }
        # 5682538: Handle <val> of <nam>=<val> with '=' characters
        # Ex: EM_TARGET_PASSWORD=db=snmp
        # Split and join does not work if value has a trailing =
        # Use index and substr instead
        my $eqpos = index($_, "=");
        my $nam = substr($_, 0, $eqpos);
        my $val = substr($_, $eqpos+1);

            if($val eq "__BeginProp__")
            {
        while(<STDIN>)
        {
          if($_ ne "__EndProp__\n")
          {
            $r{"$nam"} .= "$_";
          }
          else { last; }
        }
      }
      else
      {
        $r{"$nam"} = "$val"; 
      }

    }
exiting:
    return %r;
}
# This subroutine will be used to retrive data from a file.
# The data in the file must be saved through save_last_sample()
sub retrieve_last_sample
{
    my ($fn) = @_;

    my $last_time;
    my $db_up_time;
    my %last_value;

    open (INPUT, $fn) || warn "Could not open file $fn: $!\n";

    while (<INPUT>) {
        my $i = 0;
        my @last_record = split(':', $_);
        $last_time = $last_record[$i++];
        $db_up_time = $last_record[$i++];
        for ( ; $i <= $#last_record; $i++ ) {
            my @d = split ('=', $last_record[$i]);
            $last_value{$d[0]} = $d[1];
        }
    }

    close (INPUT);

    return ($last_time, $db_up_time, %last_value);
}

# This subroutine will be used to save the current data into a file.
# Those data can be retrieved through retrieve_last_sample()
sub save_last_sample
{
    my ($fn, $now, $db_up_time, %value) = @_;

    open (OUTPUT, ">$fn") || die "Could not open file $fn to write: $!\n";

    my $record = $now;
    $record = $record . ":$db_up_time";
    my $name;
    foreach $name (keys %value) {
        $record = $record . ":$name=$value{$name}";
    }

    print OUTPUT $record;
    close (OUTPUT);
}


# This subroutine will be used to modify the given property with the given 
# value in the given file.
# @args : filename, property name, property value
# @returns: In case of succesfull modification it will return the previous
# value of the property. If the given property in not found in the given file
# then it will return "FAILURE"

sub modifyProperty 
{
  my($fname, $propName, $propValue) = @_;
  
  if (! -T $fname ) {
     print "File $fname is not a text file\n";
     next; 
  }
  open(FILE,"$fname") or die "Can not read file: $fname\n$!\n";

  my $rootDir;
 
  if ( $ENV{EMSTATE} eq "" ) {
     $rootDir = $ENV{EMDROOT};
  } else {
     $rootDir = $ENV{EMSTATE};
  }
 
  my $tempFile = "$rootDir/sysman/config/so_temp_emd.properties";
  open (NEW_EMD_FILE, ">$tempFile") or die "Can not open file: $tempFile\n$!\n";

  my $entryFound = 0;

  my $name;
  my $value;

  while (<FILE>)
  {
    my $line = $_;

    if($entryFound == 0)
    {
      ;# Remove leading and traling whitespaces
      s/^\s+|\s+$//;
      s/#.*$//g;

      ;# Validate each non-empty line
      if (! /^$/)
      {
        ($name,$value) = /([^=]+)\s*=\s*(.+)/;
        if (defined($name) && defined($value))
        {
          $name  =~ s/^\s+|\s+$//g;
          $value =~ s/^\s+|\s+$//g;

          if($name eq $propName)
          {
            $entryFound = 1;
            print NEW_EMD_FILE "$propName=$propValue \n";
            next;
          }
        }
      }
    }
    print NEW_EMD_FILE $line;
  }
  close(FILE);

  close(NEW_EMD_FILE);

  if ($entryFound == 0)
  {
    return "FAILURE";
  }
  system `cp $tempFile $fname`;
  return $value;
}


# This subroutine will search through the list of ORA errors mentioned
# in the newly introduced property called "IgnoreDownOraErrors" in 
# emd.properties file, to compare the given error and return "<<<METRIC SKIP>>>"
# prefixed error if the given error is found in the list. If the given error 
# is not found in the list then it will return the given error as it is.
# Project no. 16219 FS - section 3.1.2.3
sub filterOraError
{
  my $argsListSize = @_;
  my $userErrMsg = shift(@_);
  my $inOraError = shift(@_);    
  my $addnlOraErrorsBool;
  my $addnlOrOverrideDownOraErrors;
  if($argsListSize > 2)
  {
    $addnlOraErrorsBool = shift(@_);
    $addnlOrOverrideDownOraErrors = shift(@_);
  }

  my $rootDir;
  if ( $ENV{EMSTATE} eq "" ) {
     $rootDir = $ENV{EMDROOT};
  } else {
     $rootDir = $ENV{EMSTATE};
  }
  my $emdPropFile = "$rootDir/sysman/config/emd.properties";
  my (%agentProps) =  &parseFile($emdPropFile);
  my  $ignoreDownOraErrorsPropName = "IgnoreDownOraErrors";
  if (defined($agentProps{$ignoreDownOraErrorsPropName}))
  {
    my $ignoreDownOraErrors = $agentProps{$ignoreDownOraErrorsPropName};
    my @ignoreDownOraErrorList = split(/,/, $ignoreDownOraErrors);
    my @addnlOrOverrideDownOraErrorsList = 
    split(/,/,$addnlOrOverrideDownOraErrors);  
    my @finalIgnoreOraErrorList;
    if ($argsListSize > 2)
    {
      if ($addnlOraErrorsBool eq "TRUE")
      {
        @finalIgnoreOraErrorList = 
                    (@ignoreDownOraErrorList, @addnlOrOverrideDownOraErrorsList);
      }
      else
      {
        @finalIgnoreOraErrorList =  @addnlOrOverrideDownOraErrorsList;
      }
    }
    else
    {
      @finalIgnoreOraErrorList =  @ignoreDownOraErrorList;
    }
    my $oraErrListSize = @finalIgnoreOraErrorList;
    for (my $i=0; $i < $oraErrListSize; $i++)
    {
      if( $inOraError ==  $finalIgnoreOraErrorList[$i])
      {
         return  "<<<METRIC SKIP>>>".$userErrMsg;
      }
    }
  }
  return $inOraError;
}

# This subroutine will parse the emd.prop file format and 
# return hashTable which will contain all properties and values
sub parseFile
{
  my($fname) = @_;
  my %lprop;

  if (! -T $fname ) {
     print "File $fname is not a text file\n";
     next;
  }
  open(FILE,$fname) or die "Can not read file: $fname\n$!\n";
  while (<FILE>) {
    ;# Remove leading and traling whitespaces
    s/^\s+|\s+$//;
    s/#.*$//g;

    ;# Validate each non-empty line
    if (! /^$/) {
       my($name,$value) = /([^=]+)\s*=\s*(.+)/;
       if (defined($name) && defined($value)) {
          $name  =~ s/^\s+|\s+$//g;
          $value =~ s/^\s+|\s+$//g;
          $lprop{$name} = $value;
       }
    }
  }
  close(FILE);

  ;# Return success
  return %lprop;
}

#
#  Only Secure channel agent operations set this environment variable.
#
sub _isUserPerlExecution
{
  my $ret = 0;

  if ( defined($ENV{USER_PERL_EXECUTION}) && ($ENV{USER_PERL_EXECUTION} eq "1") )
  {
    $ret = 1;
  }

  return $ret;
}

#
#  For Secure channel agent operations this env variable needs to be set inorder to get
#  tracing
#
sub _isUserPerlTraceDirSet
{
  my $ret = 0;

  if ( defined($ENV{USER_PERL_TRACE_DIR}) && ($ENV{USER_PERL_TRACE_DIR} ne "")  )
  {
    $ret = 1;
  }

  return $ret;
}


#
# trace error info for EMD perl scripts
#
sub EMD_PERL_ERROR
{
    my ($message) = @_;

    # always write the error message
    EMD_PERL_TRACE ("ERROR: ", $message);
}

#
# trace warning info for EMD perl scripts
#
sub EMD_PERL_WARN
{
    my ($message) = @_;

    if ( defined($ENV{EMAGENT_PERL_TRACE_LEVEL}) && $ENV{EMAGENT_PERL_TRACE_LEVEL} ne "" ) {
        # get the current trace level
        my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};

        # only write the message if the current trace level is DEBUG or INFO or WARN
        if ( $trace_level <= $EMAGENT_PERL_TRACE_LEVEL_WARN ) {
            EMD_PERL_TRACE ("WARN: ", $message);
        }
    }
}

#
# trace normal info for EMD perl scripts
#
sub EMD_PERL_INFO
{
    my ($message) = @_;

    if ( defined($ENV{EMAGENT_PERL_TRACE_LEVEL}) && $ENV{EMAGENT_PERL_TRACE_LEVEL} ne "" ) {
        # get the current trace level
        my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};

        # only write the message if the current trace level is DEBUG or INFO
        if ( $trace_level <= $EMAGENT_PERL_TRACE_LEVEL_INFO ) {
            EMD_PERL_TRACE ("INFO: ", $message);
        }
    }
}

#
# trace debug info for EMD perl scripts
#
sub EMD_PERL_DEBUG
{
    my ($message) = @_;

    if ( defined($ENV{EMAGENT_PERL_TRACE_LEVEL}) && ($ENV{EMAGENT_PERL_TRACE_LEVEL} ne "") ) {
        # get the current trace level
        my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};

        # only write the message if the current trace level is DEBUG
        if ( $trace_level == $EMAGENT_PERL_TRACE_LEVEL_DEBUG ) {
            EMD_PERL_TRACE ("DEBUG: ", $message);
        }
    }
}

#
# write the trace message into file emd_perl.trc
# the default tracing directory will {EMDROOT}/sysman/log/
# users can specify their own directory by setting {EMAGENT_PERL_TRACE_DIR}
# the default maximum size of the trace file is 5M.
# users can ch;tange that number by setting {EMAGENT_PERL_TRACE_FILESIZE}
#
sub EMD_PERL_TRACE
{
    my ($level, $message) = @_;

    # get the trace file with the full path
    my $trace_file;
    my $backup_trace_file;
    if (_isUserPerlExecution() == 1)
    {
      # Secure channel operation so tracing should go to a user defined location
      # if location is not set, we will not trace anything
      if (_isUserPerlTraceDirSet() == 1)
      {
        $trace_file =$ENV{USER_PERL_TRACE_DIR} . "/user_perl.trc"; 
        $backup_trace_file = $ENV{USER_PERL_TRACE_DIR} . "/.user_perl.trc";
      }
      else
      {
        return;
      }
    }
    else
    {
      #Agent user operation, so tracing should go to the agent state dir

      if ( defined($ENV{EMAGENT_PERL_TRACE_DIR}) && $ENV{EMAGENT_PERL_TRACE_DIR} ne "") 
      {
        $trace_file = $ENV{EMAGENT_PERL_TRACE_DIR} . "/emagent_perl.trc";
        $backup_trace_file = $ENV{EMAGENT_PERL_TRACE_DIR} . "/.emagent_perl.trc";
      } 
      else 
      {
        if ( defined($ENV{EMSTATE}) && $ENV{EMSTATE} ne "" ) 
        {
          $trace_file = $ENV{EMSTATE} . "/sysman/log/emagent_perl.trc";
          $backup_trace_file = $ENV{EMSTATE} . "/sysman/log/.emagent_perl.trc";
        } 
        else 
        {
          $trace_file = $ENV{EMDROOT} . "/sysman/log/emagent_perl.trc";
          $backup_trace_file = $ENV{EMDROOT} . "/sysman/log/.emagent_perl.trc";
        }
      }
    }

    # open the trace file
    open (TRACE, ">>$trace_file") || return;

    # open the trace file succeed
    # get the current time
    my $cur_time = localtime;

    # get the script file name (without the directory)
    my $filename = basename ($0, "");

    # append the message
    print TRACE "$filename: $cur_time: $level $message\n";
    TRACE->autoflush(1);

    # close the trace file
    close (TRACE);

    # default the max trace file size is 5MB
    my $file_max_size = 5 * 1024 * 1024;
    if ( defined($ENV{EMAGENT_PERL_TRACE_FILESIZE}) && $ENV{EMAGENT_PERL_TRACE_FILESIZE} ne "" ) {
        $file_max_size = $ENV{EMAGENT_PERL_TRACE_FILESIZE} * 1024 * 1024;
    }

    # rename the file to the backup file if the size is over the maximum size
    my $file_size = -s $trace_file;
    if ( $file_size > $file_max_size ) {
        if (!rename $trace_file, $backup_trace_file) {
            print "Could not rename file $trace_file : $!\n";
        }
    }
}

sub EMAGENT_isPerlDebugEnabled
{
    # get the current trace level
    my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};
    return  $trace_level ne "" 
               && 
            $trace_level == $EMAGENT_PERL_TRACE_LEVEL_DEBUG; 
}

sub EMAGENT_isPerlInfoEnabled
{
    # get the current trace level
    my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};
    return  $trace_level ne "" 
                && 
            $trace_level <= $EMAGENT_PERL_TRACE_LEVEL_INFO; 
}

sub EMAGENT_isPerlWarningEnabled
{
    # get the current trace level
    my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};
    return  $trace_level ne "" 
                && 
            $trace_level <= $EMAGENT_PERL_TRACE_LEVEL_WARN; 
}

#
# trace error info for EMAGENT perl scripts
#
sub EMAGENT_PERL_ERROR
{
    my ($message) = @_;

    # always write the error message
    EMD_PERL_TRACE ("ERROR: ", $message);
}

#
# trace warning info for EMAGENT perl scripts
#
sub EMAGENT_PERL_WARN
{
    my ($message) = @_;

    if ( EMAGENT_isPerlWarningEnabled() ) {
        # only write the message if the current trace level is DEBUG or INFO or WARN
        EMD_PERL_TRACE ("WARN: ", $message);
    }
}

#
# trace normal info for EMAGENT perl scripts
#
sub EMAGENT_PERL_INFO
{
    my ($message) = @_;

    if ( EMAGENT_isPerlInfoEnabled() ) {
        # only write the message if the current trace level is DEBUG or INFO
        EMD_PERL_TRACE ("INFO: ", $message);
    }
}

#
# trace debug info for EMAGENT perl scripts
#
sub EMAGENT_PERL_DEBUG
{
    my ($message) = @_;

    if ( EMAGENT_isPerlDebugEnabled() ) {
        # only write the message if the current trace level is DEBUG
        EMD_PERL_TRACE ("DEBUG: ", $message);
    }
}

1;



