#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/emd_dbcommon.pl /main/5 2011/07/14 09:51:51 glavash Exp $
#
# emd_dbcommon.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emd_dbcommon.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    glavash     07/13/11 - conditionally include Oraperl for ocm envs
#    danili      12/09/08 - Creation
# 

#ignore error if Oraperl not found in OCM home; only use if NOT in OCM environment
eval 'use Oraperl' if (! defined $ENV{CCR_HOME});

#registers a perl script with the database it is connected to
sub register_metric_call
{
    my ($lda) = @_;
    my $sql = q{
        BEGIN  
            dbms_application_info.set_module('Oracle Enterprise Manager.Metric Engine', '' ); 
        END;
    };
    &ora_do($lda, $sql) || warn "error registering - ora_do : $ora_errno: $ora_errstr\n";;
}		

# get the database version
# currently, valid DB version will be "8", "8i", "9i"
sub get_db_version
{
    my ($lda) = @_;

    my $sql = "select banner from v\$version where banner like 'Oracle%'";
    my $cur = &ora_open ($lda, $sql) || warn "ora_open ($lda, $sql): $ora_errno: $ora_errstr\n";
    my @fetch_row = &ora_fetch($cur);
    &ora_close($cur) || warn "ora_close($cur): $ora_errno: $ora_errstr\n";

    my $db_version = substr($fetch_row[0], 6, 2);
    $db_version =~ s/\s//g;

    return $db_version;
}

# get the database startup time
sub get_db_up_time
{
    my ($lda) = @_;

    my $sql = "select TO_CHAR(STARTUP_TIME, 'MM/DD/YYYY/HH24/MI/SS') from v\$instance";
    my $cur = &ora_open ($lda, $sql) || warn "ora_open ($lda, $sql): $ora_errno: $ora_errstr\n";
    my @fetch_row = &ora_fetch($cur);
    &ora_close($cur)  || warn "ora_close($cur): $ora_errno: $ora_errstr\n";

    my $db_up_time = $fetch_row[0];

    return $db_up_time;
}

1;
