# $Header: emagent/sysman/admin/scripts/emd_ulimit_host.pl /main/1 2010/10/15 09:55:17 nparaddi Exp $
#
# emd_ulimit.pl
# 
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emd_ulimit.pl - Get the ulimit -a for the emd process
#
#    DESCRIPTION
#      Gets the ulimit -a properties for the emd process. The idea is that
#      emd runs as the same user as the db user and thus the ulimit 
#      properties for the db user is known
#
#    NOTES
#      ulimit -a is currently available only on Sun, AIX and DEC
#
#    MODIFIED   (MM/DD/YY)
#    nparaddi    10/05/10 - change semd_common to semd_common_ocm
#    njagathe    11/24/04 - Handle NT 
#    aaitghez    11/02/04 - bug 3843531. add Mac OS support 
#    kduvvuri    09/15/04 - add tracing. 
#    mbhoopat    03/10/04 - linux port 
#    skumar      01/09/04 - 10G Linux changes 
#    xxu         09/08/03 - correct parsing error 
#    vsekuboy    10/09/02 - Added condition for SunOS 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    dmshah      05/23/02 - bug fix 2384359
#    dmshah      04/03/02 - dmshah_support_host_metris
#    dmshah      04/02/02 - Creation
# 

require "semd_common_ocm.pl";
require "emd_common_ocm.pl";

$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/lib:/etc";

my $os = get_osType();

# Nothing to return on Windows
if ( $os eq "WIN") {
  exit;
}

EMD_PERL_DEBUG("Processing ulimit on $os");

# The order of values: cpu time, file, data, stack, memory, coredump, nofiles, vmemory
#
# On AIX, the vmemory part is not returned

if ($os eq "HP" || $os eq "OSF1" || $os eq "AIX" || $os eq "Darwin" || 
    $os eq "LNX" ) {
    $ntime=`sh -c "ulimit -t"`; chomp($ntime); 
    $nfile=`sh -c "ulimit -f"`; chomp($nfile); 
    $ndata=`sh -c "ulimit -d"`; chomp($ndata); 
    $nstack=`sh -c "ulimit -s"`; chomp($nstack); 
    $ncore=`sh -c "ulimit -c"`; chomp($ncore); 
    $nnofiles=`sh -c "ulimit -n"`; chomp($nnofiles); 
    $nmem=`sh -c "ulimit -m"`; chomp($nmem); 

    EMD_PERL_DEBUG("on OS:$os,ntime=$ntime,nfile=$nfile,ndata=$ndata,\
nstatc=$nstack,ncore=$ncore,nnofiles=$nnofiles,nmem=$nmem"); 
    print "em_result=$ntime|$nfile|$ndata|$nstack|$ncore|$nnofiles|$nmem\n"; 
    exit; 
} elsif ($os eq "SOL") {
    $ntime=`ksh -c "ulimit -t"`; chomp($ntime); 
    $nfile=`ksh -c "ulimit -f"`; chomp($nfile); 
    $ndata=`ksh -c "ulimit -d"`; chomp($ndata); 
    $nstack=`ksh -c "ulimit -s"`; chomp($nstack); 
    $ncore=`ksh -c "ulimit -c"`; chomp($ncore); 
    $nnofiles=`ksh -c "ulimit -n"`; chomp($nnofiles); 
    $nmem=`ksh -c "ulimit -v"`; chomp($nmem); 

    EMD_PERL_DEBUG("on OS:$os,ntime=$ntime,nfile=$nfile,ndata=$ndata,\
nstatc=$nstack,ncore=$ncore,nnofiles=$nnofiles,nmem=$nmem"); 
    print "em_result=$ntime|$nfile|$ndata|$nstack|$ncore|$nnofiles|$nmem\n"; 
    exit; 
}
else {
   EMD_PERL_DEBUG("on OS:$os Not implemented");
   print "Not implemented on $os\n";
   exit;
}

