#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/emdcpudetails.pl /st_emagent_10.2.0.1.0/3 2008/11/18 18:29:53 nigandhi Exp $
#
# emdcpudetails.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      emdcpudetails.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nigandhi    11/17/08 - Backport nigandhi_bug-7557353 from main
#    nigandhi    10/02/08 - XbranchMerge nigandhi_proj-26388_cpu_5 from main
#    nigandhi    09/04/08 - TopN Report metric
#    nigandhi    09/04/08 - Creation
# 

require "emd_common.pl";
use Time::Local;

#sub EMD_PERL_DEBUG
#{
#  my $msg = shift;
#  print "$msg\n";
#}

my $hourOffset = 0;
my $numArgs = $#ARGV +1;
my $ret = 1;

if ($numArgs < 1)
{
  print STDERR "Usage: perl emdcpudetails.pl <AgentStateDir> [<offset>]\n";
  exit (1);
}

my $agentStateDir = $ARGV[0];
my $cpuTrackDir = $agentStateDir. "/sysman/emd/cputrack";
EMD_PERL_DEBUG("CPUTrackDir=$cpuTrackDir");

# if arg present, search file in the history
if ($numArgs > 1)
{
  $hourOffset = $ARGV[1] + 0;
  EMD_PERL_DEBUG("Entering emdcpudetails.pl: houroffset=*$hourOffset*");
  if ($hourOffset < 0)
  {
    print STDERR "Invalid offset\n";
    exit(1);
  }
}

if ($hourOffset > 0)
{
  $ret = get_past_snapshot($hourOffset);
}
else
{
  $ret = get_current_snapshot();
}
exit($ret);

sub get_past_snapshot()
{
  my $ret = 1;
  my $offsetHour = shift;
  EMD_PERL_DEBUG("In get_past_snapshot($offsetHour)");

  my $offsetInSec = time - ($offsetHour * 3600);
  my $foundFile = get_past_snapshot_file($offsetInSec);
  if ($foundFile)
  {
    $ret = print_file($foundFile);
  }
  else
  {
    print STDERR "CPU dump is not available for the specified hour offset\n";
  }
  return $ret;
}

sub get_past_snapshot_file()
{
  my $offsetSec = shift;
  my $foundFile = "";
  my $filepath = "";
  my $fileStartTime = 0;
  my %filestartTimes;
  EMD_PERL_DEBUG("In get_past_snapshot_file($offsetSec)");

  opendir(CPUDIR, $cpuTrackDir) || die "couldnt open directrory: $!";
  while (defined(my $file = readdir(CPUDIR))) 
  {
    if( $file =~ m/^emagent/ )
    {
      $filepath = "$cpuTrackDir/$file";
      $fileStartTime = get_scheduled_snapshot_starts($filepath);
      if ($fileStartTime > 0)
      {
        $filestartTimes{$filepath}=$fileStartTime;
      }
    }
  }
  closedir(CPUDIR);
  EMD_PERL_DEBUG("---------------------");
  # sort in descending order and pick the closet one in range
  my $count=0;
  my $file="";
  my $snapIntervalStr = "";
  my $endDateTime = "";
  my $fileStartTimeSec = 0;
  my $endRangeSec = 0;
  my $outofrange=0;
  foreach $file (sort { $filestartTimes{$b} cmp $filestartTimes{$a} } keys %filestartTimes)
  {
    $fileStartTimeSec = $filestartTimes{$file};
    EMD_PERL_DEBUG("$file : $fileStartTimeSec");

    if ($count == 0)
    {
      #this is the last snapshot history available - lets get its endtime.
      #if the endtime is out of range then quit - nothing to return
      $snapIntervalStr = get_snapshot_interval($file);
      $snapIntervalStr =~ m/Interval=(.*) (.*) - (.*) (.*)/;
      $endDateTime = $3 . " " . $4;
      $endRangeSec = get_epoch_seconds($endDateTime);
      EMD_PERL_DEBUG("EndRangeSec - $endRangeSec");
      if ($offsetSec > $endRangeSec)
      {
        EMD_PERL_DEBUG("RequestedSec $offsetSec : last history file end time: $endRangeSec");
        $outofrange = 1;
        last;
      }
    }

    if ($fileStartTimeSec < $offsetSec)
    {
      $foundFile = $file;
      last;
    }
    $count ++;
  }

  if( (!$foundFile) && ($outofrange==0) )
  {
    EMD_PERL_DEBUG("RequestedSec $offsetSec : earliest history file start Time= $fileStartTimeSec");
  }

  return $foundFile;
}

#Determine if the passed in snapshot file is a scheduled snapshot file or not
sub get_scheduled_snapshot_starts()
{
  my $fullpath = shift;
  my $startDateTime = "";
  my $endDateTime = "";
  my $schedStartTimeSec = 0;
  my $startSec = 0;
  my $endSec = 0;
  my $intervalString = "";

  $intervalString = get_snapshot_interval($fullpath);

  $intervalString =~ m/Interval=(.*) (.*) - (.*) (.*)/;
  $startDateTime = $1 . " " . $2;
  $endDateTime = $3 . " " . $4;
  $startSec = get_epoch_seconds($startDateTime);
  $endSec = get_epoch_seconds($endDateTime);
  if (($endSec - $startSec) >= 3600)
  {
    $schedStartTimeSec = $startSec;
  }

  EMD_PERL_DEBUG("$fullpath - $schedStartTimeSec");

  return $schedStartTimeSec;
}

sub get_epoch_seconds()
{
  my $dateTime = shift;
  my $epoch_seconds = 0;

  ($yyyy, $mm, $dd, $hh, $min, $sec) = ($dateTime =~ /(\d+)-(\d+)-(\d+) (\d+):(\d+):(\d+)/);

  $epoch_seconds = timelocal($sec, $min, $hh, $dd, $mm-1, $yyyy);
  return $epoch_seconds;
}

#get the interval string from the file
sub get_snapshot_interval()
{
  my $fullpath = shift;
  my $linecount = 0;
  my $strInterval="";

  open INPUT, "$fullpath" ;
  # print all lines that match grepStr
  while($input = <INPUT>)
  {
    if ($input =~ m/Interval=(.*) (.*) - (.*) (.*)/ )
    {
      $strInterval = $input;
      last;
    }
    $linecount ++;
    if($linecount == 10)
    {
      #something is wrong with this cpu diagtrace - skip this file
      last;
    }
  }
  close INPUT;
  
  return $strInterval;
}

#get a new snapshot file
sub get_current_snapshot()
{
  EMD_PERL_DEBUG("In get_current_snapshot()");

  my $cmd=`$ENV{ORACLE_HOME}/bin/emctl status agent cpu` or die "emctl status agent cpu failed.\n";
  my $genfile = "";
  my $ret = 1;

  #extract name of the file to read
  if ( $cmd =~ /.*Agent Thread CPU Snapshot available in file: (.*)/ )
  {
    $genfile = $1;
    $ret = print_file($genfile);
  }

  return $ret;
}

sub print_file()
{
  my $dumpFile = shift;
  my $ret = 1;
  if ($dumpFile)
  {
    # $/ - input record separator (default is "\n) "
    undef $/;

    open INPUT, "$dumpFile";
    my $whole_file = <INPUT>;
    close(INPUT);

    #delete the file after reading contents
    unlink($dumpFile);

    print $whole_file;
    $ret = 0;
  }

  return $ret;
}








