#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/emdcpusummary.pl /st_emagent_10.2.0.1.0/3 2008/10/06 14:45:48 nigandhi Exp $
#
# emdcpusummary.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      emdcpusummary.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nigandhi    10/02/08 - XbranchMerge nigandhi_proj-26388_cpu_5 from main
#    nigandhi    09/10/08 - CollectionInterval arg
#    nigandhi    09/04/08 - Adding code to parse topNReport
#    nigandhi    07/28/08 - ThreadCPUUsageSummary Metric
#    nigandhi    07/28/08 - Creation
# 

require "emd_common.pl";

EMD_PERL_DEBUG("Entering emdcpusummary.pl");

my $snapshot = "";
my $collectInterval = 0;

$numArgs = $#ARGV +1;
# if arg present, send "snapshot" string to emctl command
if ($numArgs > 0)
{
  $collectInterval = $ARGV[0];
  if ($collectInterval != 0)
  {
    $snapshot = "snapshot";
  }
}

EMD_PERL_DEBUG("Snapshot flag=$snapshot : $collectInterval");

my $cmd=`$ENV{ORACLE_HOME}/bin/emctl status agent cpu ${snapshot}` or die "emctl status agent cpu failed.\n";

#extract name of the file to read
if ( $cmd =~ /.*Agent Thread CPU Snapshot available in file: (.*)/ )
{
  $dumpFile = $1;
}

my $beginParsing=0;
my $endParsing=0;
my $timestamp = "";
my $HttpListener = 0;
my $Scheduler = 0;
my $HealthMonitor = 0;
my $CollectionThreads = 0;
my $DispatcherThreads = 0;
my $JobThreads = 0;
my $RecvletThreads = 0;
my $fields=0;

$ret = 1;
if ($dumpFile)
{
  open INPUT, "$dumpFile" ;
  # print all lines that match grepStr
  while($input = <INPUT>)
  {
    chomp($input);

    if ($input =~ /^Summary/ )
    {
      $beginParsing=1;
      next;
    }

    if ($input =~ /^Top / )
    {
      $endParsing = 1;
      last;
    }

    if ( $input =~ /^Interval=(.*)/ )
    {
      $timestamp = $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^HttpListener=(.*)%/ )
    {
      $HttpListener= $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^Scheduler=(.*)%/ )
    {
      $Scheduler = $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^HealthMonitor=(.*)%/ )
    {
      $HealthMonitor = $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^CollectionThreads=(.*)%/ )
    {
      $CollectionThreads = $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^DispatcherThreads=(.*)%/ )
    {
      $DispatcherThreads = $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^JobThreads=(.*)%/ )
    {
      $JobThreads = $1;
      $fields = $fields +1;
    }
    elsif ( $input =~ /^RecvletThreads=(.*)%/ )
    {
      $RecvletThreads = $1;
      $fields = $fields +1;
    }

    if ($fields == 8)
    {
      $ret = 0;
      last;
    }

  }
  close(INPUT);

  if ($snapshot ne "snapshot")
  {
    #delete the file after reading contents
    unlink($dumpFile);
  }
}

my $outText = "${HttpListener}|${Scheduler}|${HealthMonitor}|${CollectionThreads}|${DispatcherThreads}|${JobThreads}|${RecvletThreads}|${timestamp}";

if ($ret != 0)
{
  print STDERR "Error parsing ${dumpFile}: Fields do not match: Partial Results:\n${outText}\n";
}
else
{
  print "em_result=${outText}\n";
}

exit($ret);






