#
# $Header: emagent/sysman/admin/scripts/emdiscoveryhelper.pm /main/11 2012/03/15 13:48:16 kduvvuri Exp $
#
# emdiscoveryhelper.pm
#
# Copyright (c) 2002, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emdiscoveryhelper.pm - helper routines for discovery scripts.
#
#    DESCRIPTION
#    Reads Oui inventory to gather info about oracle products. Provides
#    a set of methods that can be used by various discovery scripts.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       kduvvuri 03/07/12 - bug 13796410.
#       kduvvuri 03/16/11 - fix bug 11839013.
#       njagathe 05/28/10 - Look at 32 bit inv on 64 bit windows
#       kganapat 04/02/09 - XbranchMerge kganapat_lrg-3815204 from
#                           st_emagent_10.2.0.1.0
#       kganapat 04/01/09 - Map platform dir value in s_macros.xml according to
#                           the OUI/bin/<dirname> before oraparam.ini lookup 
#       kganapat 03/20/09 - XbranchMerge kganapat_bug-8326911 from
#                           st_emagent_10.2.0.1.0
#       kganapat 03/16/09 - Rely on JRE_MEMORY_OPTION from oraparam.ini to
#                           decide whether -d64 option needs to be passed or
#                           not in shiphome case
#       amathur  01/06/08 - add hybrid java switch Bug 6685796, backport 651496
#       kduvvuri 08/15/05 - fix emagentSDK.jar path. 
#       kduvvuri 08/12/05 - fix 4551263. 
#       kduvvuri 07/25/05 - fix 4510519 - packaging issues. 
#       kduvvuri 06/05/05 - kduvvuri_bug-4225469
#       kduvvuri 06/03/05 - put more comments about the useage. 
#       kduvvuri 06/02/05 - review comments. 
#       kduvvuri 05/25/05 - fix the example. 
#       kduvvuri 05/20/05 - add getInventoryLocs. 
#       kduvvuri 05/10/05 - more dev. 
#       kduvvuri 05/05/2005  - created.
#

package emdiscoveryhelper;

use Exporter;
@ISA = ('Exporter');
@EXPORT_OK = ('getOracleHomes','getProductsForOracleHome', 
              'getOracleHomesForProduct','getJavaHome','getInventoryLocations');

my $oraHome = $ENV{'ORACLE_HOME'};

require "emdcommon.pm";
my $osType = emdcommon::get_osType();
my $cpSep = ":";

if($osType eq "WIN")
{
  $cpSep = ";";
}

my $LOG_CATEGORY = "EM_DISCOVERY_HELPER: ";

#construct the dir location where OuiInventories.add file is.
if ( defined $ENV{EMSTATE} ) 
{
  my $ecmInvDir;
  my $sysmanDir;
  my $ecmPath ;
  $sysmanDir= File::Spec->catfile($ENV{EMSTATE}, "sysman");
  $ecmInvDir = File::Spec->catfile($sysmanDir,"config");
  $ecmPath =  File::Spec->canonpath($ecmInvDir);
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY setting ECM Inventory location to:$ecmPath");
  $ENV{'ecmInvLoc'} = $ecmPath ;
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY ecmInvLoc is set to:$ENV{ecmInvLoc}");
}
else 
{
  emdcommon::EMD_PERL_INFO("$LOG_CATEGORY can't get EMSTATE to construct ECM Inventory location.");
}


sub getJavaHome
{
  # use java from 'appropriate' location
  my $JAVA_HOME="";

  $JAVA_HOME="$oraHome/jdk";

die "Cannot determine JAVA_HOME\n" if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME/bin"));

   return $JAVA_HOME;
}

#The function 'getOracleHomes' returns a  reference to an array consisting of 
#oracle homes read from OUI.
#Typical useage:
# use emdiscoveryhelper('getOracleHomes')
# $oraclehomes = getOracleHomes();
# $numHomes=@$oraclehomes;
# for ( $i = 0; $i < $numHomes; $i++ ) {
#    print "$oraclehomes->[$i] \n";
# }

sub getOracleHomes
{
 #print "getOracleHomes called\n";
 return getInfoFromInventory("getorahomes");
}

#returns a reference to an array consisting of products for oracle home
#This function expects oracle home as an argument..
sub getProductsForOracleHome
{
  $numArgs = scalar(@_);
  if ( $numArgs != 1 ) 
  {
    die "Must specify oracleHome  as an argument to geOracleHomesForProduct";
  }
  $oh = $_[0];
  return getInfoFromInventory("getprodsforoh","$oh");
}

#returns a reference to an array consisting of oracle homes for product.
#This function expects oui component name as an argument.
sub getOracleHomesForProduct
{
  $numArgs = scalar(@_);
  if ( $numArgs != 1 ) 
  {
    die "Must specify product name as an argument to getOracleHomesForProduct";
  }
  $oh = $_[0];
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY getOracleHomesForProduct called");
  return getInfoFromInventory("getohsforprod", "$oh");
}


#returns a reference to an array containing an array of strings representing
#inventory locations.
sub getInventoryLocations
{
 emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY getInventoryLocations called");
 return getInfoFromInventory("getInvLocs");
}

sub getInfoFromInventory
{
  $option = $_[0];
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY processing option $option");
  my $savePath = $ENV{PATH};
  my $javaAdditionalOptions = "";

  if($osType eq "WIN")
  {
    $ENV{PATH} = "$oraHome/oui/lib/win32\;$savePath";
  }

  if (use64BitJava())
  {
    $javaAdditionalOptions = $javaAdditionalOptions."-d64";
  }

  $JAVA_HOME = getJavaHome();

  open (HOMES_READER, "$JAVA_HOME/bin/java  $javaAdditionalOptions -DinvPtr=$ENV{invPtr} -DecmInvLoc=$ENV{ecmInvLoc} -DoracleHome=$ENV{oracleHome} -cp $oraHome/jlib/emConfigInstall.jar$cpSep$oraHome/oui/jlib/share.jar$cpSep$oraHome/oui/jlib/OraInstaller.jar$cpSep$oraHome/jlib/srvm.jar$cpSep$oraHome/sysman/jlib/emcoreAgent.jar$cpSep$oraHome/sysman/jlib/emagentSDK.jar oracle.sysman.emSDK.emd.conf.InventoryLoader @_ |");


  while($homeLine = <HOMES_READER>)
  {
    $homeLine =~ s/^\s*//;
    chomp($homeLine);
    #print "Line read for option $option is $homeLine\n";
    push(@InventoryInfo,$homeLine);
    emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY Add OUI InvInfo=$homeLine for discovery $option" );
  }
  close HOMES_READER;

  # Also pick up 32 bit homes on 64 bit windows */
  if($osType eq "WIN" && toReadWin32InvOn64Bit())
  {
    open (HOMES_READER, "$JAVA_HOME/bin/java  $javaAdditionalOptions -DWin32HomesOn64=true -DinvPtr=$ENV{invPtr} -DecmInvLoc=$ENV{ecmInvLoc} -DoracleHome=$ENV{oracleHome} -cp $oraHome/jlib/emConfigInstall.jar$cpSep$oraHome/oui/jlib/share.jar$cpSep$oraHome/oui/jlib/OraInstaller.jar$cpSep$oraHome/jlib/srvm.jar$cpSep$oraHome/sysman/jlib/emcoreAgent.jar$cpSep$oraHome/sysman/jlib/emagentSDK.jar oracle.sysman.emSDK.emd.conf.InventoryLoader @_ |");


    while($homeLine = <HOMES_READER>)
    {
      $homeLine =~ s/^\s*//;
      chomp($homeLine);
      #print "Line read for option $option is $homeLine\n";
      push(@InventoryInfo,$homeLine);
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY Add OUI InvInfo=$homeLine for discovery $option" );
    }
    close HOMES_READER;
  }

  $ENV{PATH} = $savePath;

  return (\@InventoryInfo);

}

sub use64BitJava
{
  my $my_ret = 0;

  if (defined $ENV{'ADE_VIEW_ROOT'})
  {
      # this is a view
      my $ade_view_root = $ENV{'ADE_VIEW_ROOT'};
      my $build_ins_dir = $ade_view_root."/buildtools/install";
      my $macros_file = $build_ins_dir."/s_macros.xml";
      my $oui_bin_dir = $ade_view_root."/oui/bin";
      my $oui_platform = "";
      my $my_jre_options = "";

      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is a view");

      #parse the macros file and get the value of platform dir
      if (!(-f "$macros_file" && -r "$macros_file"))
      {
          emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY $macros_file is either not present or unreadable");
          return isJDKHybridOnPlatform();
      }

      open (MACROS_FILE,"<$macros_file") or return 0;
      while (<MACROS_FILE>)
      {
        if ($_ =~ /PLATFORM_DIR/g)
        {
          #change the line and remove extra chars
          if ($_ =~ /\s*value=\"([^\s]+)"\/>s*$/i)
          {
                    $oui_platform = $1;
          }

        }
      }
      close MACROS_FILE;

      #oui maintains the directory structure as oui/bin/hpunix whereas 
      #PLATFORM_DIR attribute has the value as hpia64 in s_macros.xml
      if ( $oui_platform eq "hpia64")
      {
        $oui_platform="hpunix";
      }

      my $oui_oraparam_ini_file = $oui_bin_dir."/".$oui_platform."/oraparam.ini";
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY OUI_ORAPARAM_INI_FILE $oui_oraparam_ini_file");

      #parse the oraparam.ini file and get the JRE_MEMORY_OPTIONS variable
      if (!(-f "$oui_oraparam_ini_file" && -r "$oui_oraparam_ini_file"))
      {
          emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY $oui_oraparam_ini_file is either not present or unreadable");
          return isJDKHybridOnPlatform();
      }

      open (ORAPARAM_FILE,  "<$oui_oraparam_ini_file") or return 0;
      while (<ORAPARAM_FILE>)
      {
        if ($_ =~ /JRE_MEMORY_OPTIONS/g)
        {
          if ($_ =~ /JRE_MEMORY_OPTIONS=\"(.*)"$/i)
          {
              $my_jre_options = $1;
              emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY JRE_MEMORY_OPTIONS $my_jre_options");
          }
        }
      }
      close ORAPARAM_FILE;

    if ($my_jre_options =~ m/-d64/g)
    {
      $my_ret = 1;
    }
  }
  else
  {
    # this is a shiphome
    my $oracleHomeSh = $ENV{'ORACLE_HOME'};
    my $oui_oraparam_ini_file_in_sh = $oracleHomeSh."/oui/oraparam.ini";
    my $my_jre_options_sh = "";
    emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY OUI_ORAPARAM_INI_FILE $oui_oraparam_ini_file_in_sh");

    #parse the oraparam.ini file and get the JRE_MEMORY_OPTIONS variable
    if (!(-f "$oui_oraparam_ini_file_in_sh" && -r "$oui_oraparam_ini_file_in_sh"))
    {
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY $oui_oraparam_ini_file_in_sh is either not present or unreadable");
      return isJDKHybridOnPlatform();
    }

    open (ORAPARAM_FILE_SH,  "<$oui_oraparam_ini_file_in_sh") or return 0;
    while (<ORAPARAM_FILE_SH>)
    {
      if ($_ =~ /JRE_MEMORY_OPTIONS/g)
      {
        if ($_ =~ /JRE_MEMORY_OPTIONS=\"(.*)"$/i)
        {
          $my_jre_options_sh = $1;
          emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY JRE_MEMORY_OPTIONS $my_jre_options_sh");
        }
      }
    }
    close ORAPARAM_FILE_SH;

    if ($my_jre_options_sh =~ m/-d64/g)
    {
      $my_ret = 1;
    }
  }

  return $my_ret;
}

sub isJDKHybridOnPlatform()
{
  $myosbuild=$^O;
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY PERL_OSBUILD $myosbuild\n");

  $myosarch="none\n";

  if ( $myosbuild eq "solaris" )
  {
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is Solaris \n");
      open (MYSOLARCH, "isainfo -kv |");
      $myosarch = <MYSOLARCH> ;
      close MYSOLARCH;
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY SOL_ARCH $myosarch\n");
      if ( $myosarch =~ /64/g )
      {
          emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is a 64 bit env \n");
          return 1;
      }

  }

  if ( $myosbuild eq "hpux" )
  {
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is HPUX \n");
      open (MYHPUXARCH, "getconf KERNEL_BITS |");
      $myosarch = <MYHPUXARCH> ;
      close MYHPUXARCH;
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY HPUX_ARCH $myosarch\n");
      if ( $myosarch =~ /64/g )
      {
         emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is a 64 bit env \n");
         return 1;
      }
  }

  return 0;
}

sub isWin64
{
  my $my_ret = 0;

    my $oracleHomeSh = $ENV{'ORACLE_HOME'};
    my $install_platform_in_sh = $oracleHomeSh."/install.platform";
    emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY OUI_INSTALL_PLATFORM_FILE $install_platform_in_sh");

    #parse the install.platform file and get the ID variable
    if (!(-f "$install_platform_in_sh" && -r "$install_platform_in_sh"))
    {
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY $install_platform_in_sh is either not present or unreadable");
      return 0;
    }

    open (INSTALLPLAT_FILE_SH,  "<$install_platform_in_sh") or return 0;
    while (<INSTALLPLAT_FILE_SH>)
    {
      if ($_ =~ /ID/g)
      {
        if ($_ =~ /ID=(.*)$/i)
        {
          $my_platform_sh = $1;
          emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY JRE_MEMORY_OPTIONS $my_platform_sh");
        }
      }
    }
    close INSTALLPLAT_FILE_SH;

    if ($my_platform_sh =~ m/233/g)
    {
      $my_ret = 1;
    }

  return $my_ret;
}

#Check to see if we need to read 32bit oui inventory on 64bit windows.
#Determine this based on the presence of env variable
#ProgramFiles(x86).  
#Caller of this method already should check if we are on windows env. 
sub toReadWin32InvOn64Bit
{
  my $my_ret = 0;

  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY checking to see if env variable ProgramFiles(x86) variable is present.");

  if ( defined ($ENV{'ProgramFiles(x86)'} ) )
  {
    emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY env variable ProgramFiles(x86) is present.");
    $my_ret = 1;
  }
  else 
  {
    emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY env variable ProgramFiles(x86) is  not defined in the env.");
   
   $my_ret = 0;
  }
  return $my_ret;
}

1;
