# $Header: emagent/sysman/admin/scripts/emdl_discovery.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:28 pnayak Exp $
#
# emdl_discovery.pl
# 
# Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      emdl_discovery.pl - Standby discovery script for emdlite targets
#
#    DESCRIPTION
#      Discovers and configures Host and DB targets. This script is a 
#      standby discovery script to configure targets.xml for emdlite
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    05/05/03 - Replaced uname with ^O
#    vsekuboy    04/29/03 - oratab location for platforms is /etc/oratab  
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    dmshah      01/27/02 - Merged dmshah_fix_emdlctl
#    dmshah      01/27/02 - Creation
# 
nmep_generateTargetsXML();

sub nmep_generateTargetsXML
{
  nmep_getEnvironment (); # obtain env. values like HOSTNAME and EMDROOT
  nmep_openTargetFile();  # open file descriptor to $EMDROOT/sysman/emd/targets.xml
  nmep_printStartTag ();  # Print the start tag
  nmep_getHostEntry();    # Print the host target
  nmep_getDatabaseEntries(); # Get and Print the db Targets
  nmep_printEndTag();     # Close the end tag
  nmep_closeTargetFile(); # Close the file
}

sub nmep_getEnvironment 
{
  use Env qw(HOSTNAME EMDROOT);
}

sub nmep_openTargetFile
{
 my $target_file="$EMDROOT/sysman/emd/targets.xml";

 unless( open TARGET,"> $target_file")
 {
  die "Cannot create $target_file. $!";
 }
}

sub nmep_closeTargetFile
{
  close TARGET;
}

sub nmep_selectTargetFile
{
 select TARGET;
}

sub nmep_selectStdout
{
 select STDOUT;
}

sub nmep_printStartTag
{
    nmep_selectTargetFile();
    print"<Targets>\n";
}

sub nmep_printEndTag
{
    print"</Targets>\n";
}

sub nmep_getHostEntry
{
    print"  <Target TYPE=\"host\" NAME=\"$HOSTNAME\" VERSION=\"1.0\">\n";
    print"  </Target>\n";
}

sub nmep_getDatabaseEntries 
{
  my (@db_entries, @valid_db, @credentials, $sid, $oracleHome,$remain, $total_db, $vdb);

  @db_entries = nmep_getOratabEntries();

  # Get the length of the db list. Note that the subscript starts from 0 and
  # hence needs to be accounted in the "for" clause.

  $total_db = @db_entries - 1;

  # Weed out any db entries with unviable SID (like * etc ...)
  for $i( 0..$total_db)
  {
    ($sid, $oracleHome , $remain) = split(/:/ , $db_entries[$i] , 3);
    $sid =~ s/\s*$//;
    if($sid ne "*")
    {
        #print" Pushing data : $db_entries[$i] \n";
        push @valid_db,$db_entries[$i];
    }
  }

  $total_db = @valid_db + 0;

  if( $total_db > 0 )
  {
      nmep_selectStdout();
      print" \n Discovered $total_db databases. In order to monitor them \n" ;
      print" please enter database credentials at the prompt for each \n\n";
      nmep_selectTargetFile();
  }

  foreach $entry (@valid_db)
  {
    ($sid, $oracleHome , $remain) = split(/:/ , $entry , 3);

    #sid is already stripped of leading white space.  
    #remove leading and trailing white space.
    $sid =~ s/\s*$//;
    $oracleHome =~ s/^\s*//;
    $oracleHome =~ s/\s*$//;

    if ( (length($sid) > 0 ) && (length($oracleHome) > 0 ) ) 
    {
       @credentials = nmep_getDBCredentials( $sid, $oracleHome );
       if((length($credentials[0]) > 0) && (length($credentials[1]) > 0) && (length($credentials[1]) > 0))
       {
         #nmep_printXml($sid,$oracleHome);
         print "  <Target TYPE=\"oracle_database\" NAME=\"$sid\" VERSION=\"1.0\">\n";
         print "     <Property NAME=\"MachineName\" VALUE=\"$HOSTNAME\"/> \n";
         print "     <Property NAME=\"UserName\" VALUE=\"$credentials[0]\" ENCRYPTED=\"FALSE\"/> \n";
         print "     <Property NAME=\"password\" VALUE=\"$credentials[1]\" ENCRYPTED=\"FALSE\"/> \n";
         print "     <Property NAME=\"OracleHome\" VALUE=\"$oracleHome\"/> \n";
         print "     <Property NAME=\"Port\" VALUE=\"$credentials[2]\"/> \n";
         print "     <Property NAME=\"SID\" VALUE=\"$sid\"/> \n";
         print "  </Target>\n";
       }
    }

  }
}


# Function getDBCredentials
# For a given SID and OracleHome, prompts the User to enter the
# username and password and port on which the db listens and returns
# an array of credentials and port.

sub nmep_getDBCredentials
{
  my( @credentials, $username, $password, $port );
  
  nmep_selectStdout();
  print" Press <ENTER> to skip monitoring \n";
  print" Please enter credentials and port to monitor $_[0] at $_[1] \n";
  print" Username : ";
  chomp($username = <STDIN>);
  print" Password : ";
  chomp($password = <STDIN>);
  print" Port : ";
  chomp($port = <STDIN>);
  print"\n";
  nmep_selectTargetFile();


  push @credentials,$username;
  push @credentials,$password;
  push @credentials,$port;

  return @credentials;
}


#Get the oratab file entries
# A typical oratab entry is of the form
# orcl:/private1/oracle/804orcl:N
#
# Returns list of the form
# { Sid1:Oracle_home1 Sid2:Oracle_home2 ... SidN:Oracle_homeN }
sub nmep_getOratabEntries 
{

  my (@entries,$oratabFile,$Oratab,$oraLine); 

  $oratabFile = nmep_getOratabFile();
  
  if ( $oratabFile ne "" ) {
    if ( open(Oratab, $oratabFile) ) {
      while ($oraLine=<Oratab>) {
        chomp($oraLine);
        #strip all leading  white space characters.
        $oraLine =~ s/^\s*//;
        if( ($oraLine =~ /^\#/ ) || ( length($oraLine) <= 0 ) ) {
          #print "discarding  \"$oraLine\" ,since it is a comment \n"
          next;
        }
        #print STDERR "$oraLine\n";
        #TODO , check if it is a new sid 
        push @entries,$oraLine;
      } 
      close(Oratab);
    }
  }
  return @entries;
}

sub nmep_getOratabFile {
   my $uname=$^O;

   if ( $uname eq "solaris" ) {
	return "/var/opt/oracle/oratab";
   }
   else {
	return "/etc/oratab";
   }
}
