#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/esa_config.pl /main/7 2011/05/20 05:50:21 mperugu Exp $
#
# esa_config.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      esa_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mperugu     04/14/11 - look the properties file under AgentState Direcory
#    hpalitan    11/12/09 - Bug #8445070
#    manosing    06/09/08 - 
#    dsukhwal    09/21/05 - add bulk sub 
#    dkjain      05/12/05 - dkjain_bug-4360523_main
#    dkjain      05/11/05 - Creation
# 

use strict ;
require "emd_common.pl";
use XML::Parser;

my %cached; #indicates whether a hash (%defaultMRCHAsh) has been retrieved 
                #from the template file to represent the default MRCs of policies
                #$cached{<target_type>} will be 1 if $defaultMRCHAsh{<target_type>}
                #is a defined hash ref for default policies of <target_type>
my %defaultMRCHAsh;


#return zero when max count is zero
#return zero when no value is specified for a policy 
sub get_max_upload_rowcount(){

 my ($targetType,$policyName) = @_;
 my $propertiesFile ;
 my @info ;
 my $line ;
 my $maxCount = 0;
 my $agentOHome = $ENV{'ORACLE_HOME'};
 $propertiesFile = "$agentOHome/sysman/config/esa/$targetType.properties";

 unless (open ( FILE, $propertiesFile)){
   #If file is missing, upload no data. 
   #print some log to indicate file is missing.
#Changing ERROR to DEBUG while printing message based on bug 8445070. Returning 0 means maxRowCount.pl will use the default value '25'
  EMD_PERL_DEBUG("File $propertiesFile was not found at location $agentOHome/sysman/config/esa");
   return 0;
 }

 my @valueResult ;
 my $len ;
 @info = <FILE> ;
 foreach $line (@info){
  if(($line =~ /^\s*$policyName(.*)/)){
       @valueResult = split(/=/,$line);
       $len = @valueResult ;
       if(($len < 2)||($len > 2)){
        EMD_PERL_ERROR("Max Count Value for the Policy $policyName not set properly"); 
        $maxCount = 0 ;
       }
       elsif($policyName eq trim($valueResult[0])){
         $maxCount = validate_max_count(trim($valueResult[1]),$policyName);
       }
       else{
        EMD_PERL_ERROR("Max Count Value for the Policy $policyName not set properly"); 
        $maxCount = 0 ;
       }
       last ;
   }
 }
 return $maxCount ;
}


sub get_max_upload_rowcount_bulk{
 my $targetName = shift;
 my $targetType = shift;
# my @policyList = @_;
 my %maxCountHash;
 my $propertiesFile ;
 my @info ;
 my $line ;
 my $line_num=0;
 my $maxCount = 0;
 my $agentState = $ENV{'EMSTATE'};
 $propertiesFile = "$agentState/sysman/config/$targetName\_$targetType.properties";

 unless (open ( FILE, $propertiesFile)){
   #If file is missing, upload no data. 
   #print some log to indicate file is missing.

#Changing ERROR to DEBUG while printing message based on bug 8445070. Returning 0 means maxRowCount.pl will use the default value '25'
  EMD_PERL_DEBUG("File $propertiesFile was not found at location $agentState/sysman/config");
   return 0;
 }

 my @valueResult ;
 my $len ;
 @info = <FILE> ;
 close FILE;
 foreach $line (@info){
   $line_num++;
   @valueResult = split(/=/,$line);
   $len = @valueResult ;
   if(($len < 2)||($len > 2)){
    EMD_PERL_ERROR("Max Count Value not set properly in file $propertiesFile line no. $line_num"); 
   }
   else{
		$maxCountHash{trim($valueResult[0])} = validate_max_count(trim($valueResult[1]),trim($valueResult[0]));
	}
  }	
  return \%maxCountHash;
}


sub trim
{
  my $origStr = $_[0];
  #Strip trailing and leading
  $origStr =~ s/^\s*|\s*$//g;
  return $origStr;
}

sub validate_max_count(){
 my ($maxCount,$policyName) = @_ ;
 my @valueResult = split(/ /,$maxCount);
 my $lenArray = @valueResult ;
 if(($lenArray > 1)||($maxCount =~ m/[^0-9]/)||($maxCount eq "")){ 
    if($maxCount eq "All"){
      return "-1" ;
    }
    EMD_PERL_ERROR("Max Count Value for the Policy $policyName not set properly:maxCount:$maxCount"); 
    return 0;
 }
 else{    #if $maxCount contains digits only
    return $maxCount;
 }
}

sub get_maximum_row_count{
# first argument is the target_type
# second optional argument is the XML file path to parse
# Return value is a reference to a hash %resultHash of the following structure.
# %resultHash = {'version' => <version attribute in XML>, 
#                'target_type' => <type attribute in XML>,
#                'targets' => \%targetsHash}
# %targetsHash = {<target name> => \%policiesHash}
# %policiesHash = {<policy name> => \%MRCHash}
# %MRCHash = {'MRC' => <MRC value defined in the XML>}
#To access any MRC value, use
#   my $res = get_maximum_row_count(<target type>); 
#   $res->{'targets'}->{<target name>}->{<policy name>}->{'MRC'}
# This value will be undef if corresopnding value in the XML is not specified.
# If there is any error in parsing the file, the value -1 wil be returned, and the error variable $@ set
    my $tt = shift;
    my $doc = shift;
    
    my %resultHash;
    my %targetsHash;
    if(!(defined($doc))){
        $doc = "$ENV{EMDROOT}/sysman/config/esa/".$tt.".xml";
    }
    my $parser = XML::Parser->new(Style => 'Tree', ErrorContext => 2);
    my $tree;
    eval{
        $tree = $parser->parsefile($doc, ErrorContext => 3);
    };
    if($@)
    {
        return -1;
    }
    
    
    my $docMain = ${$tree}[0]; #should be TargetConfiguration
    my $configVer = ${${${$tree}[1]}[0]}{'version'}; #should be 1.0
    my $targetType = ${${${$tree}[1]}[0]}{'type'}; #should be host
    $resultHash{'version'} = $configVer;
    $resultHash{'target_type'} = $targetType;
    $resultHash{'hasDuplicates'} = 0; #if one target is listed twice

    my @targetsArray = @{${$tree}[1]}; #This should be the array holding hashes for targets(except the first element of this array which is a hash that holds the attributes of TargetConfiguration element
    shift(@targetsArray);#removing the attrib hash
    
    for(my $i=0; $i<scalar(@targetsArray); $i+=2){
        my %targetInfo;
        if($targetsArray[$i] eq "0"){#All white spaces between elements are seen as text nodes with the text as white space.
            next;
        }
        else{
            my %targetAttribHash = %{${$targetsArray[$i+1]}[0]};
            my @policyArray = @{$targetsArray[$i+1]};
            shift(@policyArray);
            for(my $j=0; $j<scalar(@policyArray); $j+=2){
                my %policyInfo;
                if($policyArray[$j] eq "0"){
                    next;
                }
                else{
                    if(!(defined(${$policyArray[$j+1]}[0]))){
                        next;
                    }
                    my %policyAttribHash = %{${$policyArray[$j+1]}[0]};
                    $policyInfo{'name'} = $policyAttribHash{'name'};
                    $policyInfo{'MRC'} = $policyAttribHash{'MRC'};
                    if($policyInfo{'MRC'} eq "All"){
                        $policyInfo{'MRC'} = -1;
                    }
                    $targetInfo{$policyAttribHash{'name'}} = \%policyInfo;
                }
            }
            if(defined($targetsHash{$targetAttribHash{'name'}})){
                $resultHash{'hasDuplicates'} = 1;
            }
                
            $targetsHash{$targetAttribHash{'name'}} = \%targetInfo;
        }
    }
    $resultHash{'targets'} = \%targetsHash;
    return \%resultHash;
}



sub getTargets{
#first argument is the target type
#returns an array of target names that are being monitored by the agent currently
    my $target_type = shift;
    my @targets;
    my $sysCommand = "$ENV{EMDROOT}/bin/emctl config agent listtargets |";
    open(P, $sysCommand);
    my $line;
    while($line = <P>){
        if(!($line =~ m/\[(.*)\,(.*)\]/)){
            next;
        }
        $line =~ s/(\s*)\,(\s*)/\,/; # remove white spaces adjacent to comma
        $line =~ s/\[(.*)\,(.*)\]/$1\,$2/;
        if($2 eq $target_type){#filter out other target types
            push(@targets, $1);
        }
    }
    return @targets;
}    

sub writeConfigXML{
#first argument is a reference to a hash of the structure described with the sub get_maximum_row_count
#second (optional) argument is the filename where to write(if -1, the text is returned instead of written into a file)
#This subroutine will write the XML information into the file as specified in the second argument or 
#determine the file from the target type field of the hash
#it will return 1 to indicate success, and -1 to indicate lack of it.
    my $inHash = shift;
    my $fileName = shift;
    my $fileText; #text finally to be written into the file
    if(!defined($fileName)){
        $fileName = "$ENV{EMDROOT}/sysman/config/esa/".$inHash->{'target_type'}.".xml";
    }

    $fileText = "<TargetConfiguration version=\"".$inHash->{'version'}."\" type=\"".$inHash->{'target_type'}."\" >\n";
    my %targetsHash = %{$inHash->{'targets'}};
    my $tgt; my $plc;
    foreach $tgt (sort keys %targetsHash){
        if(!($tgt)){
            next;
        }
        $fileText = $fileText."    <Target name=\"".$tgt."\">\n";
        my %policiesHash = %{$targetsHash{$tgt}};
        foreach $plc (sort keys %policiesHash){
            if(!($plc)){
                next;
            }
            my $mrc = $policiesHash{$plc}->{'MRC'};
            if($mrc =~ m/default/i){
                $mrc = getDefaultMRC($inHash->{'target_type'}, $plc);
            }
            $fileText = $fileText."        <Policy name=\"".$plc."\" MRC=\"".$mrc."\" />\n";
        }
        $fileText = $fileText."    </Target>\n";
    }
    $fileText = $fileText."</TargetConfiguration>";
    if($fileName == -1){
        return $fileText;
    }
    open(W, ">$fileName") or return -1;
    print W $fileText;
    close(W);
    return 1;
}

sub syncConfigXML{
#This subroutine syncs the ESA configuration XML with the targets currently being monitored.
#it will remove the entries for any targets that are no more being monitored, and add entries
#for any new targets(these new values will use the default MRCs deteremined from the template XML file)
#first argument is target type
#second argument is a reference to the hash currently stored in the file
#returns the new configuration hash
    my $target_type = shift;
    my $configHash = shift;
    
    
    if($configHash == -1){
        $configHash =  get_maximum_row_count($target_type, "$ENV{EMDROOT}/sysman/config/esa/".$target_type.".xml.template");
    }
    my %targetsHash = %{$configHash->{'targets'}};
    my @targets = getTargets($target_type);
    my %seen;
    my $toWriteFile = $configHash->{'hasDuplicates'}; #whether to bother about writing the hash 
                                                      #into the configuration file. We want to 
                                                      #remove duplicates targets, the configuration 
                                                      #information for the later target will prevail

    #Add config info for newly introduced targets
    for(my $i=0; $i<scalar(@targets); $i++){
        if(defined($targetsHash{$targets[$i]})){#the $i'th target is being monitored currently, and its 
                                  #configuration info is also present in the XML file, so leave it unchanged
            $seen{$targets[$i]} = 1;
            next;
        }
        else{#a new target seems to have been added since the XML was last updated
            $toWriteFile = 1;
            getDefaultMRC($target_type);#ensure that the default MRCs are cached for $target_type
            $targetsHash{$targets[$i]} = $defaultMRCHAsh{$target_type};
            $seen{$targets[$i]} = 1;
        }
    }

    #Remove config info of deleted targets
    my $tgt;
    foreach $tgt (keys %targetsHash){
        if(!(defined($seen{$tgt}))){
            $toWriteFile = 1;
            delete $targetsHash{$tgt};
        }
    }
    
    $configHash->{'targets'} = \%targetsHash;
    if($toWriteFile == 1){
        writeConfigXML($configHash);
    }
    return $configHash;
}

sub getDefaultMRC{
#reads the template file for $targetType and returns the default MRC for $policy.
#if $policy is not given, only caches, and returns 1.
#after being called once, caches the hashref into $defaultMRCHAsh{$targetType}, and 
#sets $cached{$targetType} to 1
    my $targetType = shift;
    my $policy = shift;
    if($cached{$targetType} == 1){
        if(defined($policy)){
            return $defaultMRCHAsh{$targetType}->{$policy}->{'MRC'};
        }
        else{
            return 1;
        }
    }
    #The target type could not be found cached, so cache and return
    my $templateHash = get_maximum_row_count($targetType, "$ENV{EMDROOT}/sysman/config/esa/".$targetType.".xml.template");
    my %templatePolHash = %{$templateHash->{'targets'}->{'sample'}};
    $defaultMRCHAsh{$targetType} = \%templatePolHash;
    $cached{$targetType} = 1;
    if(defined($policy)){
        return $defaultMRCHAsh{$targetType}->{$policy}->{'MRC'};
    }
    else{
        return 1;
    }
}
    
1;

