# $Header: emagent/sysman/admin/scripts/filesystems.pl /st_emagent_10.2.0.1.0/3 2010/01/25 09:56:46 nasounda Exp $
#
# filesystems.pl
# 
# Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      filesystems.pl 
#
#    DESCRIPTION
#      This file generates output about the filesystems on the system in
#      the followign format:
#      em_result=<file_sys_name>|<size of file system>| \
#                <space used>| \
#                <space available for file creation by nonpriv users>| \
#                <% available>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nasounda    12/22/09 - Bug: 7500907
#    ssalunke    10/15/08 - Adding total disk utilization metric
#    sacgoyal    10/13/04 - 
#    skumar      08/12/04 - use hostGenFunctions
#    skumar      02/02/04 - Creation
# 


use hostGenFunctions;
use strict;

my @diskinfo;
my %diskCaps = ();
my @fields = ();
my $line;
my $usedpct;

my $mntpt;
my $dev;
my $totalkb;
my $usedkb;
my $availkb;
my $availpct;
my @exclude_fs;
my $exclude_flag;
my $file_name = "$ENV{ORACLE_HOME}/sysman/config/mntr_exclude_filesystems";

if ( (defined($ENV{EM_MONITOR_ALL_DISKS})) && (lc($ENV{EM_MONITOR_ALL_DISKS}) eq "true") && (-e $file_name) && (-r $file_name) )
{
     if ( open(FP, "< $file_name"))
     {
        @exclude_fs = <FP>;
        close FP;
     }
}

# dev totalkb usedkb availkb usedpct mntpt
@diskinfo = getDiskInfo();

foreach $line (@diskinfo)
{
  @fields = split(m/[\n\t\s]+/, $line);
  $dev = $fields[0];
  $mntpt = $fields[5];
  $totalkb = $fields[1];
  next if defined $diskCaps{$dev}; # skip duplicate entries
  $diskCaps{$dev} = $totalkb;
 
  # If the total available kb is zero, make all other dependent fields as zero 
  # since it may throw illegal division by zero error.
  if ($totalkb == 0)
  {
    $usedkb = 0;
    $availkb = 0;
    $usedpct = 0;
    $availpct = 0;
  }
  else
  {
    $usedkb = $fields[2];
    $availkb = $fields[3];
    $usedpct = $fields[4];
    $usedpct =~ s/%//;

    $availpct = $availkb/($availkb+$usedkb)*100;
  }
  $exclude_flag = 0;
  if (@exclude_fs)
  {
     foreach $line (@exclude_fs)
     {
       chomp($line);
       if (($line eq $mntpt) && ($line !=~/^#/))
       {
          $exclude_flag = 1;
          last;
       }
     }
  }
  if ($exclude_flag == 0)
  {
    printf "em_result=$mntpt|$dev|%.2f|%.2f|%.2f|%.2f\n",
         ($totalkb/1024, $usedkb/1024, $availkb/1024, $availpct);
  }
}

exit 0
