#  $Header: emagent/sysman/admin/scripts/getHome0.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:29 pnayak Exp $
#
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      getHome0.pl
#
#    DESCRIPTION
#      Method that gets central home location.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    05/05/03 - Replaced uname with ^O
#    vsekuboy    04/29/03 - corrected the oraInst.loc on linux
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    vkhizder    07/17/01 - Creation
#

# get central inventory location, aka home indexed 0

sub getHome0 {

  my $inventoryLocation;
  my $uname='';
  my $locationFile = '';

  $uname = $^O;
  if ( $uname eq "solaris" || $uname eq "hpux" ) {
  	$locationFile = "/var/opt/oracle/oraInst.loc";
  }
  else {
  	$locationFile = "/etc/oraInst.loc";
  }

  # try to find and open oraInst.loc in order to obtain central inventory location
  unless (-f $locationFile && -T $locationFile)
  {
    print "Could not find file $locationFile\n";
    exit -1;
  }

  open(INSTLOC, $locationFile) or die "Do not have access to file $locationFile\n";

  #scan the file and get the directory of where the central inventory location is
  while (<INSTLOC>)
  {
    if (/^\s*inventory_loc=\s*(\S*)\s*$/)
    {
      $inventoryLocation = $1; break;
    }
  }

  close INSTLOC;

  # return error if could not find inventory location in the file
  if (!$inventoryLocation)
  {
    print "Could not find central inventory location\n";
    exit -1;
  }

  return $inventoryLocation;
}

1;
