#!/usr/local/bin/perl
#
# $Header: emagent/sysman/admin/scripts/getHostHardwareType.pl /main/11 2012/06/23 07:39:08 tekrishn Exp $
#
# getHostHardwareType.pl
#
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getHostHardwareType.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tekrishn    06/15/12 - Include BDA hosts as ibhosts for infiniband
#                           monitoring
#    adosani     07/28/11 - exclude exalogic from infiniband monitoring as it
#                           is not supported and tested
#    cgnanasa    06/10/11 - this script to be run only on Linux/Solaris.
#    adosani     05/04/11 - Instead of using ibstat to determine Infiniband
#                           host, use the existence of required directories for
#                           Exadata and Exalogic
#    adosani     10/28/10 - Add Infiniband host hardware type
#    nasounda    07/15/09 - Including common perl routines
#    ssalunke    08/21/08 - Checking for ppc hardware
#    shnavane    07/16/07 - Backport shnavane_bug-6168902 from main
#    shnavane    07/11/07 - Fix bug #6168902
#    sacgoyal    09/24/04 - sacgoyal_gethosthardwaretype_file
#    sacgoyal    09/13/04 - Creation for Dell Hw extension of Host Mgmt, Enterprise Manager, 10.2

require "emd_common.pl";
use strict;
use File::Basename;

my $snmpd_state = 0;
my $omreport_state = 0;

#using perl to get the Operating system name. 
#reference: http://perldoc.perl.org/perlport.html#PLATFORMS
my $p_os = $^O;
if (! (($p_os =~ m/Linux/i) || ($p_os =~ m/Solaris/i) || ($p_os =~ m/SunOS/i) )  )
{
  print "em_result=Generic\n";
  exit;
}


#
# Checking if a process, whose basename is snmpd, is up and running.
#
my @psList = ();                # list of processes
@psList = `ps -eo "s args"`;
if ($? != 0)
{
  raise_error_and_exit("Failed to run ps command", 1);
}
shift @psList;       # remove ps header line
foreach my $psLine( @psList )
{
    $psLine =~ s/^\s+//;   # remove any leading space
    chomp($psLine);
    my ($state, @cmdArgs) = split(/\s+/,$psLine);
    my $command = basename($cmdArgs[0], "");

    if( $command eq "snmpd" )
    {
      $snmpd_state = 1;
      last;
    }
}
 
#
# Checking for the existence of executable /usr/bin/omreport on the host
#
if (-e "/usr/bin/omreport")
{
  $omreport_state = 1;
}


if( $snmpd_state == 1 and  $omreport_state == 1)
{
  print "em_result=Dell_PowerEdge\n";
}
else
{
  my $os = `uname`;
  my $arch = `uname -m`;
  if (($os =~ m/Linux/i) && ($arch =~ m/ppc/i))
  {
    print "em_result=PPC Based\n";
  }
  elsif (($os =~ m/Linux/i) || ($os =~ m/SunOS/i))
  {
    #my $exalogicMarker = "/var/exalogic/info/em-context.info";
    #my $exalogicMember = (-e $exalogicMarker ? 1 : 0);

    my $dbmMarker = "/opt/oracle.cellos";
    my $dbmMember = (-e $dbmMarker ? 1 : 0);

    my $bdaMarker = "/opt/oracle/bda";
    my $bdaMember = (-e $bdaMarker ? 1 : 0);

    if ($dbmMember || $bdaMember) {
      print "em_result=InfinibandHost\n";
    } else {
      print "em_result=Generic\n";
    }
  } else {
      print "em_result=Generic\n";
  }
}
 
sub raise_error_and_exit()
{
  my ($message, $exit_status) = @_;
  EMD_PERL_ERROR($message);
  print STDERR "$message \n";
  exit $exit_status;
}

