#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_common.pl /main/6 2012/06/20 10:18:57 pbhogara Exp $
#
# host_hca_common.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_hca_common.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Infiniband Host HCA common routines
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pbhogara    06/04/12 - add method to parse ibswitches output and extract
#                           name and ip
#    pbhogara    06/04/12 - get linkstate and phys link state from ibstat
#    hahegde     11/14/11 - Bug 13366015 - Adding check for dbmachine version
#    adosani     10/27/11 - ibhosts file has extra space on solaris
#    adosani     05/12/11 - sometimes ip address is not present in ibhosts file
#    adosani     11/28/10 - Creation
# 
use strict;
require "emd_common.pl";

sub check_if_ibfiles_are_readable(){
  #Check if ibhosts file exists and is readable or not. This might happen if the dbmachine version is less than 11.2.2.3
  #Passing status of 0 instead of 1 to denote success. We want the collection to continue and not abort midway especially for OCM
  my $ibHostsFile = "/opt/oracle.SupportTools/em/ibhosts";
  if (!(-r $ibHostsFile))
  {
    print("Cannot read $ibHostsFile... Aborting\n");
    exit 0;
  }
}

sub get_hca_config() {
  my %config;

  my $command = "/usr/sbin/ibstat";
  EMD_PERL_DEBUG("Get HCA configuration using command: $command");

  my @output = execute_command($command);

  my $line;
  my ($ca_name, $type, $num_ports, $firmware_ver, $hardware_ver, $node_guid, $port);
  my $order = 0;

  foreach $line (@output) {
    if ($line =~ /^CA '(\S+)'/) {
      $ca_name = $1;
    } elsif ($line =~ /CA type: (\S+)/) {
      $type = $1;
   } elsif ($line =~ /Number of ports: (\d+)/) {
      $num_ports = $1;
    } elsif ($line =~ /Firmware version: (\S+)/) {
      $firmware_ver = $1;
    } elsif ($line =~ /Hardware version: (\S+)/) {
      $hardware_ver = $1;
    } elsif ($line =~ /Node GUID: (\S+)/) {
      $node_guid= $1;
      $config{$node_guid}{Name} = $ca_name;
      $config{$node_guid}{Type} = $type;
      $config{$node_guid}{NumPorts} = $num_ports;
      $config{$node_guid}{FirmwareVersion} = $firmware_ver;
      $config{$node_guid}{HardwareVersion} = $hardware_ver;
    } elsif ($line =~ /Port (\d+)/) {
      $port = $1;
      $config{$node_guid}{Order}{$port} = $order;
      $order = $order + 1;
    } elsif ($line =~ /Port GUID: (\S+)/) {
      $config{$node_guid}{Port}{$port}{PortGUID} = $1;
    } elsif ($line =~ /State: (\S+)/) {
      $config{$node_guid}{Port}{$port}{State} = $1; # Active/Down
    } elsif ($line =~ /Physical state: (\S+)/) {
      $config{$node_guid}{Port}{$port}{PhysicalState} = $1; # Disabled/Polling/LinkUp
    }else {
      next;
    }
  }

  foreach $node_guid (keys %config) {
    $command = "cat /opt/oracle.SupportTools/em/ibhosts | grep $node_guid";
    EMD_PERL_DEBUG("Get ip address and hca name using command: $command");

    @output = execute_command($command);
  
    foreach $line (@output) {
      my ($hca) = $line =~ /.+:.+\"(.+)\"/;
      my @t = split(/\s+/, $hca);
      if (@t == 4) {
        $config{$node_guid}{IpAddr} = $t[2];
        $config{$node_guid}{DisplayName} = $t[3];
      } elsif (@t == 2) {
        $config{$node_guid}{IpAddr} = "N/A";
        $config{$node_guid}{DisplayName} = $t[1];              
      }
      last;
    }  
  }

  return %config;
}

sub execute_command() {
  my ($command) = @_;
  my @output = `$command`;
  if ($? != 0) {
    print "em_error=Failed to execute $command: @output";
    exit 1;
  } else {
    return @output;
  }
}

#
# Subroutine: Parse a fragment of ibswitches output to 
#             get the switch host name.
#
#  $_[0]  => string to be parsed.
#
#  Returns: return switch name and ip_address
#
sub parse_switch_hostname
{
  my $desc = shift;
  my $ipaddr="";
  my @words = ();
  my $hostname="";
 
  # Handle following cases:
  # Sun DCS 36 QDR switch dbm1sw-ib3.us.oracle.com
  # Sun DCS 36 QDR switch dbm1sw-ib3.us.oracle.com 10.1.2.4
  # SUN IB QDR GW switch dbm1sw-ib1 10.60.46.47
  # SUN IB QDR GW switch dbm1sw-ib1 10.60.46.47 leaf:1

  if ($desc =~ /^Sun/i) {
    my @words = split(/\s+/, $desc);
    my $last_str = pop(@words);

    if ($last_str =~ /^leaf/i) {
      $ipaddr = pop(@words);
      $hostname = pop(@words);
    }
    elsif ($last_str =~ /(\d+)\.(\d+)\.(\d+)\.(\d+)/) {
      $ipaddr = $last_str;
      $hostname = pop(@words);
    }
    else{
      $hostname = $last_str;
    }
  }
  my @arr=($hostname,$ipaddr);
  return(\@arr);
}

1;
