#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_config.pl /main/3 2011/12/07 09:43:38 hahegde Exp $
#
# host_hca_config.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_hca_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Get Infiniband Host HCA configuration by calling ibstat
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hahegde     07/07/11 - Config Compare Changes
#    adosani     11/28/10 - Creation
# 
use strict;
require "hca/host_hca_common.pl";

check_if_ibfiles_are_readable();

my %config = get_hca_config();

my $node_guid;
foreach $node_guid (keys %config) {
    print "em_result=$config{$node_guid}{DisplayName}|$node_guid|$config{$node_guid}{Name}|".
          "$config{$node_guid}{Type}|$config{$node_guid}{NumPorts}|".
          "$config{$node_guid}{FirmwareVersion}|$config{$node_guid}{HardwareVersion}|".
          "$config{$node_guid}{IpAddr}\n";
}
