#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_port_config.pl /main/4 2012/06/20 10:18:57 pbhogara Exp $
#
# host_hca_port_config.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_hca_port_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hahegde     11/14/11 - Bug 13366015 - Adding check for dbmachine version
#    hahegde     07/20/11 - Creation
#

use strict;
require "hca/host_hca_common.pl";

check_if_ibfiles_are_readable();

my %config = get_hca_config();

my %links;
my %links_temp;
my ($node_guid, $port);

my $command = "cat /opt/oracle.SupportTools/em/iblinkinfo";
EMD_PERL_DEBUG("Get Link Info using command: $command");

my @output = execute_command($command);

my $line;

foreach $line (@output) {
  my ($src, $dst) = $line =~ /(.*)==>(.*)/;  
  if (!$src) {
    EMD_PERL_WARN("Cannot parse iblinkinfo line: $line\n");
    next;
  }

  if ($dst =~ /(\S+)\s+(\d+)\s+(\d+)\[\s+\]\s+\"(.*)\"/) {
    $node_guid = $1;
    $port = $3;
    if (!exists($config{$node_guid})) {
      next;
    }
  } else {
    EMD_PERL_DEBUG("Cannot parse iblinkinfo line destination: $dst\n");
    next;
  }

  if ($src =~ /(\S+)\s+\"(.*)\"\s+(\d*)\s+(\d+)\[\s+\]\s+==\(\s*(\S+)\s+(\S+ Gbps)\s+(\S+)\s*\/\s*(\S+)\)/) {
    $links{$node_guid}{$port}{connected_to_switch_guid} = $1;
    $links{$node_guid}{$port}{connected_to_switch_port} = $4;
  } else {
    EMD_PERL_DEBUG("Cannot parse iblinkinfo line source: $src\n");
    next;
  }
}

my %state_by_order;

my $command = "cat /opt/oracle.SupportTools/em/ibportstate";
EMD_PERL_DEBUG("Get state for ports using command: $command");

my @portstate_output = execute_command($command);
  
my $order = -1;
foreach $line (@portstate_output) {
  if ($line =~ /PortInfo/) {
    $order = $order + 1;
  } elsif ($line !~ /^#/) {
    my ($key, $value) = $line =~ /(\S+):\.*(.+)$/;
    if ($key) {
      $state_by_order{$order}{$key} = $value;
    }
  }
}

foreach $node_guid (keys %config) {

  foreach $port (keys %{$config{$node_guid}{Port}}) {

    $links_temp{$node_guid}{$port} = $state_by_order{$config{$node_guid}{Order}{$port}};

    ($links{$node_guid}{$port}{LinkWidthEnabled}) = $links_temp{$node_guid}{$port}{LinkWidthEnabled} =~ /(\d+)X$/;
    ($links{$node_guid}{$port}{LinkSpeedEnabled}) = $links_temp{$node_guid}{$port}{LinkSpeedEnabled} =~ /(\d+\.?\d*) Gbps$/;
    ($links{$node_guid}{$port}{LinkWidthSupported}) = $links_temp{$node_guid}{$port}{LinkWidthSupported} =~ /(\d+)X$/;
    ($links{$node_guid}{$port}{LinkSpeedSupported}) = $links_temp{$node_guid}{$port}{LinkSpeedSupported} =~ /(\d+\.?\d*) Gbps$/;
  }
}


foreach $node_guid (keys %links) {
  foreach $port (keys %{$links{$node_guid}}) {
    print "em_result=$config{$node_guid}{DisplayName}|$port|$node_guid|".
          "$config{$node_guid}{Port}{$port}{PortGUID}|".
          "$links{$node_guid}{$port}{connected_to_switch_guid}|$links{$node_guid}{$port}{connected_to_switch_port}|".
          "$links{$node_guid}{$port}{LinkSpeedSupported}|$links{$node_guid}{$port}{LinkWidthSupported}|".
          "$links{$node_guid}{$port}{LinkSpeedEnabled}|$links{$node_guid}{$port}{LinkWidthEnabled}\n";
  }
}
 
