#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_port_connections.pl /main/6 2012/06/20 10:18:57 pbhogara Exp $
#
# host_port_metrics.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_port_metrics.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Calls ibstat, iblinkinfo.pl and perfquery to get the port metrics for the host HCAs.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hahegde     07/07/11 - Config Compare Changes
#    adosani     08/23/10 - Creation
# 
use strict;
require "emd_common.pl";
require "hca/host_hca_common.pl";

check_if_ibfiles_are_readable();

my %config = get_hca_config();

my %links;
my ($node_guid, $port);

my $command = "cat /opt/oracle.SupportTools/em/iblinkinfo";
EMD_PERL_DEBUG("Get Link Info using command: $command");

my @output = execute_command($command);

my $line;

foreach $line (@output) {
  my ($src, $dst) = $line =~ /(.*)==>(.*)/;  
  if (!$src) {
    EMD_PERL_WARN("Cannot parse iblinkinfo line: $line\n");
    next;
  }

  if ($dst =~ /(\S+)\s+(\d+)\s+(\d+)\[\s+\]\s+\"(.*)\"/) {
    $node_guid = $1;
    $port = $3;
    if (!exists($config{$node_guid})) {
      next;
    }
  } else {
    next;
  }

  if ($src =~ /(\S+)\s+\"(.*)\"\s+(\d*)\s+(\d+)\[\s+\]\s+==\(\s*(\S+)\s+(\S+ Gbps)\s+(\S+)\s*\/\s*(\S+)\)/) {
    $links{$node_guid}{$port}{connected_to_switch_guid} = $1;
    $links{$node_guid}{$port}{connected_to_switch_port} = $4;
  } else {
    next;
  }
}

foreach $node_guid (keys %links) {
  foreach $port (keys %{$links{$node_guid}}) {
    print "em_result=$node_guid|$port|$config{$node_guid}{DisplayName}|".
          "$config{$node_guid}{Port}{$port}{PortGUID}|".
          "$links{$node_guid}{$port}{connected_to_switch_guid}|$links{$node_guid}{$port}{connected_to_switch_port}\n";
  }
}

exit;
