#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_port_errors.pl /main/4 2012/05/31 03:53:10 pbhogara Exp $
#
# host_hca_port_errors.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_hca_port_errors.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Get HCA Port errors by calling perfquery
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pbhogara    05/09/12 - Fix bug13443814 on compute node
#    adosani     11/28/10 - Creation
# 
use strict;
require "emd_common.pl";
require "hca/host_hca_common.pl";

my %config = get_hca_config();
my %metrics;
my %metrics_by_order; # perfquery file stores metrics in same order as ports in ibstat

my ($node_guid, $port);

my $command = "cat /opt/oracle.SupportTools/em/perfquery";
EMD_PERL_DEBUG("Get errors for ports using command: $command");

my @output = execute_command($command);

my $line;
my $order = -1;
foreach $line (@output) {
  if ($line =~ /PortSelect/) {
    $order = $order + 1;
  } elsif ($line !~ /^#/) {
    my ($key, $value) = $line =~ /(\S+):\.*(\S+)$/;
    if ($key) {
      $metrics_by_order{$order}{$key} = $value;
    }
  }
}

foreach $node_guid (keys %config) {
  foreach $port (keys %{$config{$node_guid}{Port}}) {
    $metrics{$node_guid}{$port} = $metrics_by_order{$config{$node_guid}{Order}{$port}};
  }
}

foreach $node_guid (keys %metrics) {
  foreach $port (keys %{$metrics{$node_guid}}) {
    print "em_result=$node_guid|$port|".
          "$metrics{$node_guid}{$port}{SymbolErrors}|$metrics{$node_guid}{$port}{LinkRecovers}|".
          "$metrics{$node_guid}{$port}{RcvErrors}|".
          "$metrics{$node_guid}{$port}{RcvRemotePhysErrors}|".
          "$metrics{$node_guid}{$port}{XmtConstraintErrors}|".
          "$metrics{$node_guid}{$port}{RcvConstraintErrors}|$metrics{$node_guid}{$port}{LinkIntegrityErrors}|".
          "$metrics{$node_guid}{$port}{ExcBufOverrunErrors}|$metrics{$node_guid}{$port}{VL15Dropped}\n";
  }
}

exit;
