#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_port_state.pl /main/4 2012/06/20 10:19:02 pbhogara Exp $
#
# host_hca_port_state.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_hca_port_state.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Get HCA Port state by calling ibportstate
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pbhogara    06/06/12 - adding cols for port disabled and polling states
#    adosani     11/28/10 - Creation
# 
use strict;
require "emd_common.pl";
require "hca/host_hca_common.pl";

check_if_ibfiles_are_readable();

my %config = get_hca_config();
my %state;
my %state_by_order;

my ($node_guid, $port);

my $command = "cat /opt/oracle.SupportTools/em/ibportstate";
EMD_PERL_DEBUG("Get state for ports using command: $command");

my @output = execute_command($command);
  
my $line;
my $order = -1;
foreach $line (@output) {
  if ($line =~ /PortInfo/) {
    $order = $order + 1;
  } elsif ($line !~ /^#/) {
    my ($key, $value) = $line =~ /(\S+):\.*(.+)$/;
    if ($key) {
      $state_by_order{$order}{$key} = $value;
    }
  }
}

foreach $node_guid (keys %config) {

  foreach $port (keys %{$config{$node_guid}{Port}}) {

    $state{$node_guid}{$port} = $state_by_order{$config{$node_guid}{Order}{$port}};

    ($state{$node_guid}{$port}{LinkWidthEnabled}) = $state{$node_guid}{$port}{LinkWidthEnabled} =~ /(\d+)X$/;
    ($state{$node_guid}{$port}{LinkSpeedEnabled}) = $state{$node_guid}{$port}{LinkSpeedEnabled} =~ /(\d+\.?\d*) Gbps$/;
    ($state{$node_guid}{$port}{LinkWidthSupported}) = $state{$node_guid}{$port}{LinkWidthSupported} =~ /(\d+)X$/;
    ($state{$node_guid}{$port}{LinkSpeedSupported}) = $state{$node_guid}{$port}{LinkSpeedSupported} =~ /(\d+\.?\d*) Gbps$/;
    ($state{$node_guid}{$port}{LinkWidthActive}) = $state{$node_guid}{$port}{LinkWidthActive} =~ /(\d+)X$/;
    ($state{$node_guid}{$port}{LinkSpeedActive}) = $state{$node_guid}{$port}{LinkSpeedActive} =~ /(\d+\.?\d*) Gbps$/;

    $state{$node_guid}{$port}{LinkState} = ($state{$node_guid}{$port}{LinkState} eq 'Active' ? 1 : 0);

    my $physState = $state{$node_guid}{$port}{PhysLinkState};
    $state{$node_guid}{$port}{PhysLinkState} = ($state{$node_guid}{$port}{PhysLinkState} eq 'LinkUp' ? 1 : 0);

    if($physState eq 'LinkUp'){
      $state{$node_guid}{$port}{PortDisabled} = 0;
      $state{$node_guid}{$port}{PortPolling} = 0;
    }
    elsif($physState eq 'Disabled'){
      $state{$node_guid}{$port}{PortDisabled} = 1;
      $state{$node_guid}{$port}{PortPolling} = 0;
    }
    elsif($physState eq 'Polling'){
      $state{$node_guid}{$port}{PortDisabled} = 0;
      $state{$node_guid}{$port}{PortPolling} = 1;
    }

    $state{$node_guid}{$port}{degraded} = 
      ($state{$node_guid}{$port}{LinkWidthActive} < $state{$node_guid}{$port}{LinkWidthEnabled} || 
       $state{$node_guid}{$port}{LinkSpeedActive} < $state{$node_guid}{$port}{LinkSpeedEnabled}) ? 1 : 0;
  }
}

foreach $node_guid (keys %state) {
  foreach $port (keys %{$state{$node_guid}}) {
    print "em_result=$node_guid|$port|".
                    "$state{$node_guid}{$port}{LinkSpeedSupported}|$state{$node_guid}{$port}{LinkWidthSupported}|".
                    "$state{$node_guid}{$port}{LinkSpeedEnabled}|$state{$node_guid}{$port}{LinkWidthEnabled}|".
                    "$state{$node_guid}{$port}{LinkSpeedActive}|$state{$node_guid}{$port}{LinkWidthActive}|$state{$node_guid}{$port}{degraded}|".
                    "$state{$node_guid}{$port}{LinkState}|$state{$node_guid}{$port}{PhysLinkState}|$state{$node_guid}{$port}{PortDisabled}|$state{$node_guid}{$port}{PortPolling}|$config{$node_guid}{DisplayName}\n";

  }
}

exit;
