#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hca/host_hca_temperature.pl /main/1 2011/07/07 03:12:32 rajverma Exp $
#
# host_hca_temperature.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host_hca_temperature.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rajverma    06/22/11 - script to read temperature
#    rajverma    06/22/11 - Creation
#

use File::Basename;
use File::Spec::Functions;
use strict;
#require "emd_common.pl";

 my $temp_file = "/opt/oracle.SupportTools/em/temperature";
 my $val = "value";
 my ($temp,$dum1,$dum2); 
 my $hostname = `hostname`;
    chomp($hostname);
	
   # EMD_PERL_DEBUG("Reading the file ".$temp_file. " to get temperature");
    open (TEMP, "<$temp_file");
    my @rows = <TEMP>;
       close (TEMP);

     foreach my $row (@rows)
      {
        chomp($row);
        # Skip Blank Lines
         next unless $row;
         $row =~ s/^\s+|\s+$//g;

        if($row =~ m/^$val/ )
        {
           my( $name , $temp_str) = split("=",$row);
           ($temp,$dum1,$dum2) = split('\.', $temp_str);
            $temp = trim($temp);
           print "em_result=".$hostname."|".$temp ."\n";
         }
	else
	 {
	   #EMD_PERL_WARN("Unable to read temperature , setting to default value 0");
	    $temp = 0;

	 }
	

     }

sub trim($)
{
        my $string = shift;
        $string =~ s/^\s+//;
        $string =~ s/\s+$//;
        return $string;
}
 
