#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hostServices.pl /main/1 2010/04/10 10:42:06 nparaddi Exp $
#
# hostServices.pl
# 
# Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hostServices.pl
#
#    DESCRIPTION
#      List all user-visible servces and current state
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     06/26/06 - Creation
# 
use strict;
use Win32::Service;

my %services = ();
my %svcStatus = ();
my ($ret,$service, $svcState);

# Get hash of all services
Win32::Service::GetServices('', \%services);

foreach $service (keys %services) 
{
  # Get this service's status information
  $ret = Win32::Service::GetStatus('',$services{$service},\%svcStatus);
  if ($ret != 0)
  {
    # CurrentState can be a value from 1-7.  Only 4 is running, the remainder are some
    # other (stopped, stop pending, start pending, paused, pause pending, continue pending)
    # 
    print "em_result=$service|" . (($svcStatus{CurrentState} == 4) ? "on" : "off") . "\n";
  }
  # clear the status hash for the next pass
  %svcStatus = ();
} 
