# $Header: emagent/sysman/admin/scripts/hostcpu.pl /main/2 2010/09/30 08:30:52 nparaddi Exp $
#
# Package : hostcpu.pl
#
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostcpu.pl
#
#   DESCRIPTION
#       Collects cpu data
#
#   returns EM_RESULT = 
# with values for
#   INSTANCE_COUNT|VENDOR|FREQ_IN_MHZ|ECACHE_IN_MB|IMPL|REVISION|MASK|SIBLINGS
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      nparaddi   09/28/10 - add code to set unknown when key column is null
#      nparaddi   04/01/10 - add instance count to cpu
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;

use constant KEY_VENDOR_IDX      => '1';
use constant KEY_FREQ_IDX        => '2';
use constant KEY_ECACHE_IDX      => '3';
use constant KEY_IMPL_IDX        => '4';
use constant KEY_REVISION_IDX    => '5';
use constant KEY_MASK_IDX        => '6';
use constant KEY_NUMCORES_IDX    => '7';
use constant KEY_SIBLINGS_IDX    => '8';
use constant KEY_HYPERTHREAD_IDX => '9';

use constant NUM_FREQ_IDX        => '2';
use constant NUM_ECACHE_IDX      => '3';
use constant NUM_NUMCORES_IDX    => '7';
use constant NUM_SIBLINGS_IDX    => '8';
use constant NUM_HYPERTHREAD_IDX => '9';

my @key_columns = (KEY_VENDOR_IDX,KEY_FREQ_IDX,KEY_ECACHE_IDX,KEY_IMPL_IDX,KEY_REVISION_IDX,KEY_MASK_IDX,KEY_NUMCORES_IDX,KEY_SIBLINGS_IDX,KEY_HYPERTHREAD_IDX);
my @numaric_columns = (NUM_FREQ_IDX,NUM_ECACHE_IDX,NUM_NUMCORES_IDX,NUM_SIBLINGS_IDX,NUM_HYPERTHREAD_IDX);

#******************************************
#     Global Variables
#******************************************

    my @results;
    my $result = '';

    my @tmp = getPerCPUResults();
    my %instances = ();

    foreach my $strkey ( @tmp ) {
       $instances{$strkey}++;
    }

    foreach my $strkey ( keys %instances ) {
       push(@results,"em_result=$instances{$strkey}|$strkey\n");
    }

    # This make sure that numeric columns should have numaric values and key columns should not be null
    @results = verifyAndUpdateData(\@results,\@key_columns,\@numaric_columns);

    if ($hostOSD::SORT_RESULTS == 1)
    {
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    else
    {
      foreach $result (@results)
      {
        print $result;
      }
    }


# End of the Program
