# $Header: emagent/sysman/admin/scripts/hostdiskactivity.pl /main/13 2012/05/24 06:04:46 nasounda Exp $
#
# hostdiskactivity.pl
# 
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hostdiskactivity.pl 
#
#    DESCRIPTION
#      returns system disk activity
#
#        On Linux, the result is :
#              Device
#              Transfers per second
#              Amount of data read from drive as blocks per second
#              Amount of data written to drive as blocks per second
#              Total number of blocks read
#              Total number of blocks written
#
#
#    NOTES
#        data collected and averaged over a 2 second interval
#
#    MODIFIED   (MM/DD/YY)
#    nasounda    05/18/12 - Add a variable to set whether it is partition or
#                           disk
#    ssalunke    03/01/10 - Cleaning up DiskActivity in 11.2
#    cgnanasa    10/09/09 - Fix for bug:7676689. Formatting removed from
#                           em_result printing.
#    ssalunke    07/13/09 - Removing ram disks from the monitoring code
#    mjnoel      06/02/09 - Migrate the decvms changes forward to 10.3 label as
#                           per bug 8455777
#    bmesseng    04/03/08 - Add VMS support
#    denath      02/25/07 - Backport denath_bug_5038684 from main
#    denath      10/10/06 - fix bug 5038684.Use LIMIT_TO instance property to
#                           limit number of Disk activity rows to upload.
#    skumar      06/11/04 - /proc/diskstats in 2.6 kernel
#    skumar      01/07/04 - Creation
# 

if ($^O eq "VMS")
{
    system("mcr agent_home:[bin]vms_stats hostdiskactivity");
    exit 0;
}

exit 1 if ($^O ne "linux");

use hostGenFunctions;

$ENV{PATH} = "/usr/bin:/bin:/usr/sbin:/usr/local/bin:/local/bin";

my $RIO_TAG    = "rio";
my $RSECT_TAG  = "rsect";
my $RTICKS_TAG = "rticks";
  
my $WIO_TAG    = "wio";
my $WSECT_TAG  = "wsect";
my $WTICKS_TAG = "wticks";
  
my $TICKS_TAG  = "ticks";
my $AVEQ_TAG   = "aveq";
my $MINOR_TAG = "minor";

my $k24 = 0;

my %iostats = ();

my @data = ();
my $header;
my $uptime = 0;
my $minor = -1;

if (!open(FH, "/proc/diskstats")) { # 2.6 kernel
  open FH, "/proc/partitions" or die "Could not open /proc/partitions\n";
  $k24 = 1;
}

@data = (<FH>);
close FH;

if ($k24)
{
  @header = split(/[\s\t]+/, $data[0]);

  # Columns in /proc/partitions:
  # major minor #blocks name rio rmerge rsect ruse wio wmerge wsect wuse
  # running use aveq

  die "em_error=unknown format in /proc/partitions" if (scalar(@header) != 15);
}

# Elapsed time
$proc_uptime = `cat /proc/uptime` or die "Failed to cat /proc/uptime\n";
($uptime, $ignore) = split(/[\s\t]+/, $proc_uptime);

die "Failed to get uptime\n" if ($uptime == 0);

%iostats = get_iostats(@data);

my $count = 0 ;

foreach $key (keys %iostats)
{
    $minor = $iostats{$key}{$MINOR_TAG};
    $rio = $iostats{$key}{$RIO_TAG};
    $rsect = $iostats{$key}{$RSECT_TAG};
    $rticks = $iostats{$key}{$RTICKS_TAG};

    $wio = $iostats{$key}{$WIO_TAG};
    $wsect = $iostats{$key}{$WSECT_TAG};
    $wticks = $iostats{$key}{$WTICKS_TAG};

    $ticks = $iostats{$key}{$TICKS_TAG};

    $rticks = 0 if ($rticks < 0);
    $wticks = 0 if ($wticks < 0);


    $sum_rticks_wticks = $rticks+$wticks;
    printf("em_result=$key|$rio|$wio|$rsect|$wsect|$sum_rticks_wticks|$ticks|$minor\n");
}

exit 0;

sub get_iostats
{
  my @data = @_;
  my $size = scalar(@data);
  my %iostats;
  my $devname;

  if (!$k24)
  {
    # 2.6 kernel /proc/diskstats
    for ($i = 0; $i < $size; $i++)
    {
      $_ = trim($data[$i]);
      next if /^$/;
      next if /ram/;
      @tokens  = split(/[\s\t]+/, $_);

      $devname = $tokens[2];

      if (scalar(@tokens) == 7) # major minor name rio rsect wio wsect
      {
        $iostats{$devname}{$MINOR_TAG} = $tokens[1];
        $iostats{$devname}{$RIO_TAG} = $tokens[3];
        $iostats{$devname}{$RSECT_TAG}   = $tokens[4];
        $iostats{$devname}{$RTICKS_TAG}  = 0;

        $iostats{$devname}{$WIO_TAG}     = $tokens[5];
        $iostats{$devname}{$WSECT_TAG}   = $tokens[6];
        $iostats{$devname}{$WTICKS_TAG}  = 0;

        $iostats{$devname}{$TICKS_TAG}   = 0;
        $iostats{$devname}{$AVEQ_TAG}    = 0;
      }
      else
      {
        # major minor name rio rmerge rsect ruse wio wmerge wsect wuse
        # running use aveq

        $iostats{$devname}{$MINOR_TAG} = $tokens[1];
        $iostats{$devname}{$RIO_TAG} = $tokens[3];
        $iostats{$devname}{$RSECT_TAG}   = $tokens[5];
        $iostats{$devname}{$RTICKS_TAG}  = $tokens[6];

        $iostats{$devname}{$WIO_TAG}     = $tokens[7];
        $iostats{$devname}{$WSECT_TAG}   = $tokens[9];
        $iostats{$devname}{$WTICKS_TAG}  = $tokens[10];
  
        $iostats{$devname}{$TICKS_TAG}   = $tokens[12];
        $iostats{$devname}{$AVEQ_TAG}    = $tokens[13];
      }
    }

    return %iostats;
  }

  for ($i = 1; $i < $size; $i++)
  {
    # 2.4 kernel /proc/partitions

    $_ = trim($data[$i]);
    next if /^$/;
    next if /ram/;
  
    # major minor #blocks name rio rmerge rsect ruse wio wmerge wsect wuse
    # running use aveq

    @tokens  = split(/[\s\t]+/, $_);
    $devname = $tokens[3];
    $iostats{$devname}{$MINOR_TAG}     = $tokens[1];
    $iostats{$devname}{$RIO_TAG}     = $tokens[4];
    $iostats{$devname}{$RSECT_TAG}   = $tokens[6];
    $iostats{$devname}{$RTICKS_TAG}  = $tokens[7];
  
    $iostats{$devname}{$WIO_TAG}     = $tokens[8];
    $iostats{$devname}{$WSECT_TAG}   = $tokens[10];
    $iostats{$devname}{$WTICKS_TAG}  = $tokens[11];
  
    $iostats{$devname}{$TICKS_TAG}   = $tokens[13];
    $iostats{$devname}{$AVEQ_TAG}    = $tokens[14];
  }
  return %iostats;
}
