# $Header: emagent/sysman/admin/scripts/hosthw.pl /main/7 2012/06/20 14:59:51 smirajka Exp $
#
# Package : hosthw.pl
#
# Copyright (c) 2002, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hosthw.pl
#
#   DESCRIPTION
#       Collects hardware data
#
#   returns EM_RESULT = 
# with values for
#| 'HOSTNAME';
#| 'DOMAIN';
#|  VENDOR
#| 'SYSTEM_CONFIG';
#| 'MACHINE_ARCHITECTURE';
#| 'CLOCK_FREQ_IN_MHZ';
#| 'MEMORY_SIZE_IN_MB';
#| 'LOCAL_DISK_SPACE_IN_GB';
#| 'PHYSICAL_CPU_COUNT';
#| 'CORE_CPU_COUNT'
#| 'LOGICAL_CPU_COUNT'
#| 'CPU_BOARD_COUNT';
#| 'IOCARD_COUNT';
#| 'FAN_COUNT';
#| 'POWER_SUPPLY_COUNT';
#| 'BOOT_DISK_VOLUME_SERIAL_NUM';
#| 'SYSTEM_BIOS';
#| 'SYSTEM_SERIAL_NUMBER';
#| 'AVAIL_LOCAL_DISK_SPACE_IN_GB';
#| 'AVAIL_MEMORY_SIZE_IN_MB';
#| 'HOST_ID';
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      smirajka   06/04/12 - Add 'virtual' property to hw collection
#                            Bug-14104667
#      nparaddi   03/22/11 - add nt code
#      nparaddi   10/14/10 - add parsing df to generic code
#      nparaddi   09/28/10 - add code to verify numaric data
#      nparaddi   08/04/10 - add new ccr additions
#      nparaddi   04/13/10 - add physical cpu count to the metric
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/04/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;
use Config;

#use Carp;
#require 5.005;

#require 5.6.1;
#require Exporter;

#use ecmErrorMsgs;

#******************************************
#     Global Variables
#******************************************

use constant NOT_FOUND      => -1;
use constant COLON_CHR      => ':';
use constant DOT_CHR        => '.';
use constant NIL            => '';

use constant NUM_CLOCK_IDX          => '5';
use constant NUM_MEMORY_IDX         => '6';
use constant NUM_DISK_SPACE_IDX     => '7';
use constant NUM_PHYSICAL_CPUS_IDX  => '8';
use constant NUM_CPUS_IDX           => '9';
use constant NUM_LOGICALCPUS_IDX    => '10';
use constant NUM_BOARD_IDX          => '11';
use constant NUM_IOCARD_IDX         => '12';
use constant NUM_FAN_COUNT_IDX      => '13';
use constant NUM_POWER_COUNT_IDX    => '14';

my @key_columns     = ();
my @numaric_columns = (NUM_CLOCK_IDX,NUM_MEMORY_IDX,NUM_DISK_SPACE_IDX,NUM_PHYSICAL_CPUS_IDX,NUM_CPUS_IDX,NUM_LOGICALCPUS_IDX,NUM_BOARD_IDX,NUM_IOCARD_IDX,NUM_FAN_COUNT_IDX,NUM_POWER_COUNT_IDX);

my $NoOfBrd   = 0;
my $NoOfCards = 0;

#DO NOT supply values for avail disk or avail memory
 
my $NoOfFan         = NIL;
my $NoOfPower       = NIL;
my $avail_mem       = NIL;
my $avail_disk      = NIL;
my $boot_disk       = NIL;
my $system_bios     = NIL;
my $system_serial   = NIL; 
my $boot_disk       = NIL;
my $memory          = NIL;
my $clock           = NIL;
my $hw_name         = NIL;
my $host_id         = NIL;
my $domain          = NIL;
my $j               = 0;
my $virtualStatus   = "UNKNOWN";
    
my $hostname = getHostName();

$domain = getDomainName($hostname);

my $vendor_id = getHardwareVendor();

my $arch = getArchType();

my ($physicalCpuCount, $coreCpuCount, $logicalCpuCount) = getCpuCounts();


$NoOfCards = getIOCardCount();

$hw_name = getHardwareName();

$memory = getTotalMemory();

$NoOfBrd = 1 if ($physicalCpuCount > 0);

my $totalDiskCap = 0;

$totalDiskCap = getTotalDiskSpaceInGB();

$clock = getClockSpeed();

$host_id = getHostId();

$system_serial = getSystemSerialNumber();

# Check whether hardware is Virtual or not
$virtualStatus = getHwVirtualStatus();

my $result = "em_result=$hostname|$domain|$vendor_id|$hw_name|$arch|$clock|$memory|$totalDiskCap|$physicalCpuCount|$coreCpuCount|$logicalCpuCount|$NoOfBrd|$NoOfCards|$NoOfFan|$NoOfPower|$boot_disk|$system_bios|$system_serial|$avail_mem|$avail_disk|$host_id|$virtualStatus\n";

my @results = ($result);
@results    = verifyAndUpdateData(\@results, \@key_columns, \@numaric_columns);

print $results[0];

sub getTotalDiskSpaceInGB() 
{
    if ($Config{'osname'} eq "MSWin32")
    {
        # code for windows to written . this will be handled as part of the bug 9507863
        return getTotalDiskSpace();
    }

    my $totalDiskCap = 0;
    my @diskinfo     = getDiskInfo();
    my %diskCap      = getSortedDiskSizes(\@diskinfo);
    foreach my $diskCap ( values %diskCap) 
    {
        $totalDiskCap += $diskCap;
    }
    $totalDiskCap = sprintf("%.2f", $totalDiskCap/(1024 * 1024));
 
    return ($totalDiskCap);
}


1;

# End of the Program
