# $Header: emagent/sysman/admin/scripts/hostiocard.pl /main/2 2010/09/30 08:30:52 nparaddi Exp $
#
# Package : hostiocard.pl
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostiocard.pl
#
#   DESCRIPTION
#       Collects iocard data
#
#
#   returns potentially multiple em_result=VENDOR_NAME|NAME|FREQ_IN_MHZ|REVISION 
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      nparaddi   09/29/10 - add code to set unknown when key column is null
#      nparaddi   04/01/10 - add instance count to io cards
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;

use constant KEY_VENDOR_IDX   => '1';
use constant KEY_NAME_IDX     => '2';
use constant KEY_FREQ_IDX     => '3';
use constant KEY_BUS_IDX      => '4';
use constant KEY_REVISION_IDX => '5';

use constant NUM_FREQ_IDX     => '3';

my @key_columns = (KEY_VENDOR_IDX,KEY_NAME_IDX,KEY_FREQ_IDX,KEY_BUS_IDX,KEY_REVISION_IDX);
my @numaric_columns = (NUM_FREQ_IDX);



    my @results =();
    my $result;

    my @tmp = getIOCardResults();

    my %instances = ();

    foreach my $strkey ( @tmp ) {
       $instances{$strkey}++;
    }

    foreach my $strkey ( keys %instances ) {
       push(@results,"em_result=$instances{$strkey}|$strkey\n");
    }

    # This make sure that numaric columns will have numeric values and key columns will not be null
    @results = verifyAndUpdateData(\@results,\@key_columns,\@numaric_columns);

    if ($hostOSD::SORT_RESULTS == 1)
    {
      # sort results then print them one by one
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    else
    {      # sort results then print them one by one
      foreach $result (@results)
      {
        print $result;
      }
    }


# End of the Program
