# $Header: emagent/sysman/admin/scripts/hostmodules.pl /main/2 2010/09/30 08:30:52 nparaddi Exp $
#
# Package : hostmodules.pl
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostmodules.pl
#
#   DESCRIPTION
#       Collects os modules info from /proc/modules
#
#
#   returns potentially multiple 
# em_result=NAME|SIZE_IN_BYTES|REFERRING_MODULES
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      nparaddi   09/29/10 - add code to set unknown when key column is null
#      glavash    09/30/05 - glavash_bug-4552238
#      glavash    09/30/05 - fix comments 
#      glavash    09/27/05 - creation 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;


#******************************************
#     Global Variables
#******************************************

use constant KEY_NAME_IDX  => '0';

use constant NUM_SIZE_IDX  => '1';

my @key_columns = (KEY_NAME_IDX);
my @numaric_columns = (NUM_SIZE_IDX);


    my $result;

    my @results = getModulesResults();

    # This make sure that numaric columns should have numeric values and key columns should not be null
    @results = verifyAndUpdateData(\@results,\@key_columns,\@numaric_columns);

    # if we are sorting results sort then print
 
    if ($hostOSD::SORT_RESULTS == 1)
    {
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    # else print them array by array
    else
    {
      foreach $result (@results)
      {
        print $result;
      }
    }
1;
# End of the Program
