# $Header: emagent/sysman/admin/scripts/hostnic.pl /main/2 2010/09/30 08:30:52 nparaddi Exp $
#
# Package : hostnic.pl
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostnic.pl
#
#   DESCRIPTION
#       Collects nic card data
#
#
#   returns potentially multiple em_result=NAME|FLAGS|MAX_TRANSFER_UNIT|INET_ADDRESS|MASK|BROADCAST_ADDRESS|MAC_ADDRESS|ALIASES|DESCRIPTION|DEFAULT_GATEWAY|DHCP_ENABLED 
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      nparaddi   09/29/10 - add code to set unknown when key column is null
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;


use constant KEY_NAME_IDX => '0';

use constant NUM_MTU_IDX  => '2';
use constant NUM_PHYSICAL_IDX => '12';

my @key_columns = (KEY_NAME_IDX);
my @numaric_columns = (NUM_MTU_IDX,NUM_PHYSICAL_IDX);

   my $result;
   
   # get results
   my @nic_results = getNICResults();

   # This make sure that numaric columns should have numeric values and key columns should not be null
   @nic_results = verifyAndUpdateData(\@nic_results,\@key_columns,\@numaric_columns);

   # sort them and print them

   if ($hostOSD::SORT_RESULTS == 1)
   {
      foreach $result (sort(@nic_results))
      {
        print $result;
      }
   }
   else
   {
     foreach $result (@nic_results)
     {
       print $result;
     }
   }

# End of the Program
