#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hostnicbond.pl /main/2 2010/09/30 08:30:52 nparaddi Exp $
#
# hostnicbond.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hostnicbond.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nparaddi    09/29/10 - add code to set unknown when key column is null
#    nparaddi    04/15/10 - Creation
# 

use strict;

use hostUtil;
use hostOSD;


use constant KEY_NAME_IDX => '0';

my @key_columns = (KEY_NAME_IDX);
my @numaric_columns = ();


   my $result;

   # get results
   my @nic_results = getNICBondResults();

   # This make sure that numaric columns should have numeric values and key columns should not be null
   @nic_results = verifyAndUpdateData(\@nic_results,\@key_columns,\@numaric_columns);

   # sort them and print them

   if ($hostOSD::SORT_RESULTS == 1)
   {
      foreach $result (sort(@nic_results))
      {
        print $result;
      }
   }
   else
   {
     foreach $result (@nic_results)
     {
       print $result;
     }
   }

# End of the Program

