# $Header: emagent/sysman/admin/scripts/hostos.pl /main/6 2011/02/22 22:47:54 vdwaram Exp $
#
# Package : hostos.pl
#
# Copyright (c) 2002, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostos.pl
#
#   DESCRIPTION
#       Collects ECM_OS Metric data
#
#   returns EM_RESULT = 
# with values for
# em_result =NAME|VENDOR|BASE_VERSION|UPDATE_LEVEL|DISTRIBUTOR_VERSION|MAX_SWAP_SPACE_IN_MB|ADDRESS_LENGTH_IN_BITS|MAX_PROCESS_VIRTUAL_MEMORY|TIMEZONE|TIMEZONE_REGION|TIMEZONE_DELTA|PLATFORM_ID|PLATFORM_VERSION_ID|DBM_MEMBER|EXALOGIC_MEMBER
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      vdwaram    02/14/11 - Add indicator for Exalogic membership
#      nparaddi   10/01/10 - fix path for HostPlatformMap.xml for ccr
#      nparaddi   09/29/10 - add code to set unknown when key column is null
#      nparaddi   09/08/10 - add os runlevel
#      jsutton    06/28/10 - fix typo in check for Database Machine marker
#      jsutton    06/23/10 - Add indicator for DBMachine membership
#      aghanti    06/03/10 - add platform version id
#      glavash    08/30/05 - add platform id 
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;
use File::Spec;
use File::Basename;
use Config;
use hostOSD;
use hostUtil;
use ias::simpleXPath;

use constant NIL => '';
use constant PLATFORM_VERSION_NODATA => 'NoData';

use constant NUM_MAX_SWAP_IDX        => '5';
use constant NUM_MAXPROCESS_IDX      => '7';
use constant NUM_TIMEZONEDELTA_IDX   => '10';
use constant NUM_PLATFORMID_IDX      => '11';
use constant NUM_PLATFORMVERSION_IDX => '14';
use constant NUM_DBMMEMBER_IDX       => '15';

my @key_columns = ();
my @numaric_columns = (NUM_MAX_SWAP_IDX,NUM_MAXPROCESS_IDX,NUM_TIMEZONEDELTA_IDX,NUM_PLATFORMID_IDX,NUM_PLATFORMVERSION_IDX,NUM_DBMMEMBER_IDX);

#******************************************
#     Global Variables
#******************************************

    my $dist = NIL;
    my $vendor = NIL;
    my $name = NIL;
    my $base = NIL;
    my $update = NIL;
    my $platformId = NIL;
    my $runlevel   = NIL;
    my $defaultRunLevel = NIL;
    my $platformVersionId = NIL;


    my @result = getOSNameVendorDist();
    $name = $result[0];
    $vendor = $result[1];
    $dist = $result[2];

    ($base, $update) = split ('-', getOSRelease());

    my $swap = getMaxSwapSpace();

    $swap = sprintf("%.2f", trim($swap) / (1024 * 1024));

    my $address_length = getAddressLength();

    $platformId = getOSPlatformId($name,$vendor,$address_length);
    $runlevel   = getRunlevel();
    $defaultRunLevel = getDefaultRunLevel();
    $platformVersionId = getOSPlatformVersionId($platformId,$name,$base,$vendor);


    # these are NIL only valid NT, and CSA coll
    my $max_proc_virt_mem = NIL;
    my $tz = NIL;
    my $tz_region = NIL;
    my $tz_delta = NIL;

    # locate DB Machine marker file
    my $dbmMarker = "/opt/oracle.cellos";
    my $dbmMember = (-e $dbmMarker ? 1 : 0);
    
    # locate Exalogic Machine marker file
    my $exalogicMarker = "/var/exalogic/info/em-context.info";
    my $exalogicMember = (-e $exalogicMarker ? 1 : 0);


    my $result="em_result=$name|$vendor|$base|$update|$dist|$swap|$address_length|$max_proc_virt_mem|$tz|$tz_region|$tz_delta|$platformId|$runlevel|$defaultRunLevel|$platformVersionId|$dbmMember|$exalogicMember\n";

    my @results = ();
    push(@results,$result);

    # This make sure that numaric columns should have numeric values and key columns should not be null
    @results = verifyAndUpdateData(\@results,\@key_columns,\@numaric_columns);

    print $results[0];




sub getOSPlatformVersionId()
{
    my ($platformId, $osName, $baseVer, $osVendor) = @_;
    my $inregexp = $osName.'@'.$baseVer.'@'.$osVendor;
    my $dir = dirname($0);
    my $hostFileName = File::Spec->catdir($dir,"HostPlatformMap.xml");

    my @ref=ias::simpleXPath::simpleXPathQueryForNodes($hostFileName,"HostPlatformMap/Platform");

    foreach my $noderef ( @ref ) {
      next  if $noderef eq NIL || $noderef->{'attributes'} eq NIL;
      if( $noderef->{'attributes'}->{'platId'} == $platformId) {
        foreach my $platRef ( @{$noderef->{'children'}} ) {
          # Needed this. not sure why this has been returned null
          next if $platRef->{'attributes'} eq NIL;
          next if $platRef->{'attributes'}->{'regexp'} eq NIL;
          if ( $inregexp =~ m/$platRef->{'attributes'}->{'regexp'}/ || $platRef->{'attributes'}->{'regexp'} eq PLATFORM_VERSION_NODATA) {
            return $platRef->{'attributes'}->{'platVerId'};
          }
        }
      }
    }
    
    # default return
    return -1;
}
# End of the Program
