# $Header: emagent/sysman/admin/scripts/hostosprop.pl /main/3 2010/10/19 23:12:39 crana Exp $
#
# Package : hostosprop.pl
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostosprop.pl
#
#   DESCRIPTION
#       Collects os property data
#
#
#   returns potentially multiple 
# em_result=SOURCE|NAME|VALUE
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      crana      10/06/10 - Added Exalogic id as OS property
#      nparaddi   09/29/10 - add code to set unknown when key column is null
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm9.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;


#******************************************
#     Global Variables
#******************************************

use constant KEY_SOURCE_IDX => '0';
use constant KEY_NAME_IDX   => '1';

my @key_columns = (KEY_SOURCE_IDX,KEY_NAME_IDX);
my @numaric_columns = ();


    my $result = ();

    my @sys_def_results = getCurrSysDefnResults();
    my @sys_config_results = getSysConfigResults();
    my @dns_name_server_results = getDNSNameServersResults($hostOSD::METRIC_RESULT);
    my @exalogic_id_results = getExalogicIdResults();

    # This make sure that numaric columns should have numeric values and key columns should not be null
    @sys_def_results = verifyAndUpdateData(\@sys_def_results,\@key_columns,\@numaric_columns);
    @sys_config_results = verifyAndUpdateData(\@sys_config_results,\@key_columns,\@numaric_columns);
    @dns_name_server_results = verifyAndUpdateData(\@dns_name_server_results,\@key_columns,\@numaric_columns);
    @exalogic_id_results = verifyAndUpdateData(\@exalogic_id_results,\@key_columns,\@numaric_columns);

    # if we are sorting results sort then print
    if ($hostOSD::SORT_RESULTS == 1)
    {
      my @results = ();
      my $i = 0;
      foreach $result (@sys_def_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (@sys_config_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (@dns_name_server_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (@exalogic_id_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    # else print them array by array
    else
    {
      foreach $result (@sys_def_results)
      {
        print $result;
      }
      foreach $result (@sys_config_results)
      {
        print $result;
      }
      foreach $result (@dns_name_server_results)
      {
        print $result;
      }
      foreach $result (@exalogic_id_results)
      {
        print $result;
      }
    }
1;
# End of the Program
