# $Header: hostpagingactivity.pl 03-jun-2004.08:19:38 rrawat Exp $
#
# hostpagingactivity.pl
# 
# Copyright (c) 2001, 2004, Oracle. All rights reserved.  
#
#    NAME
#      hostpagingactivity.pl 
#
#    DESCRIPTION
#      returns system buffer activity as:
#      em_result=<page out reqs per sec>|<num pages paged out per sec>|
#                <pages placed on free list by page stealing daemon per sec>|
#                <pages scanned by pages stealing daemon per sec>|
#                <igets with page flushes per sec>|
#                <page faults satisfied by memory page reclaim per sec>|
#                <page in reqs per sec>|
#                <page faults from protection errs per sec>|
#                <address translation page faults per sec>|
#                <page faults by software lock requests>
#
#    NOTES
#      data collected and averaged over a 5 second interval
#      ONLY AVAILABLE ON SUN, Linux and Tru64
#      TODO: make available from HP if possible
#
#    MODIFIED   (MM/DD/YY)
#    rrawat      06/03/04 - Bug-3667660
#    vsekuboy    10/28/02 - Modified error messages to have em_error
#    vsekuboy    10/25/02 - Changes for Tru64
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar command paging activity stats.
#    aaitghez    05/18/01 - Creation
# 

$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin:/bin";

chomp ($os = `uname -s`);

if ($os eq "SunOS") {
   # invoke sar
   $r = `sar -gp 5`
       or die "em_error=failed to execute sar";

   #parse the return string into lines
   @res = split(m/slock\/s\n/, $r);
   @row = split(m/\n/, @res[1]);

   @v1 = split(m/[\t\s]+/, @row[1]);
   $res = "em_result=@v1[1]|@v1[2]|@v1[3]|@v1[4]|@v1[5]|";
   @v2 = split(m/[\t\s]+/, @row[2]);
   $res = $res."@v2[1]|@v2[2]|@v2[3]|@v2[4]|@v2[5]|@v2[6]\n";

   print $res;
}
else {
$swap = `grep swap /proc/stat` or die "Failed to run grep";
chomp($swap);
$page = `grep page /proc/stat` or die "Failed to run grep";
chomp($page);

# pages paged in/out in 1KB blocks units
($ignore, $pgpgin, $pgpgout) = split(/[\s\t]+/, $page);

# sar -B
# pgpgin/s
#        Total  number  of blocks the system paged in
#        from disk per second.
#
# pgpgout/s
#        Total number of blocks the system paged  out
#        to disk per second.
#
# activepg
#        Number of active (recently touched) pages in
#        memory.  Note that a page has a size of 4 KB
#        or  8  KB according to the machine architec
#        ture.
#
# inadtypg
#        Number of inactive dirty (modified or poten
#        tially modified) pages in memory.
#
# inaclnpg
#        Number  of  inactive  clean  (not  modified)
#        pages in memory.
#
# inatarpg
#        "Inactive  target"  number  of  pages.  This
#        field  is a 1-minute floating average of the
#        number of pages the system needs to  "steal"
#        every  second  in  order  to  satisfy memory
#        demand.

@sarB = `sar -B` or die "em_error=failed to execute sar";
chomp($sarB[$#sarB]);
my ($ignore, $stats) = split(/:/, $sarB[$#sarB]);
@sarB = split(/[\s\t]+/, $stats);

print "em_result=$pgpgout|$sarB[3]|$sarB[4]|$sarB[5]|$pgpgin\n";

exit 0;
}
