# $Header: emagent/sysman/admin/scripts/hostsoftcomp.pl /main/2 2010/09/30 08:30:52 nparaddi Exp $
#
# Package : hostsoftcomp.pl
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostsoftcomp.pl
#
#   DESCRIPTION
#       Collects os software component data
#
#
#   returns potentially multiple 
# em_result=productname|type|version|installdate|description
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      nparaddi   09/29/10 - add code to set unknown when key column is null
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm9.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;

use constant KEY_NAME_IDX    => '0';
use constant KEY_TYPE_IDX    => '1';
use constant KEY_VERSION_IDX => '2';

my @key_columns = (KEY_NAME_IDX,KEY_TYPE_IDX,KEY_VERSION_IDX);
my @numaric_columns = ();

#******************************************
#     Global Variables
#******************************************

    my $result = ();

    my @results = getOSSoftwareComponentsResults();

    # This make sure that numaric columns should have numeric values and key columns should not be null
    @results = verifyAndUpdateData(\@results,\@key_columns,\@numaric_columns);

    # if we are sorting results sort then print
    if ($hostOSD::SORT_RESULTS == 1)
    {
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    # else print them without sorting 
    else
    {
      foreach $result (@results)
      {
        print $result;
      }
    }
1;
# End of the Program
