#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hoststorageUtil.pl /main/7 2012/04/30 03:24:21 rajverma Exp $
#
# hoststorageUtil.pl
# 
# Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hoststorageUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rajverma    07/07/11 - fix bug 11934376
#    rajverma    05/22/08 - Script to get the config parameters for hoststorage
#    rajverma    05/22/08 - Creation
# 

use storage::Utilities;

$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/sbin:$ENV{EMDROOT}/bin";

 my $os_name = `uname -s`;
 chomp($os_name);
#Check if Os is supported or not
 @os_list =  storage::Utilities::getConfig("OS");
 my $hs_support = 0;
      foreach my $opsys (@os_list)
        {
          if (uc($opsys) eq uc($os_name))
            {
                $hs_support = 1 ;
             }
        }

 my  @limit_list = storage::Utilities::getConfig("Limit");


   print "em_result=Operating System|$hs_support\n";

   foreach $line(@limit_list)
    {
       $line =~ s/_Limit=/|/;
     print "em_result=$line \n";
    }

  my $file_chg = 0 ;

# check if the config file is modified or not. 
# check if the default values of collection have changes.
# check if the disks/filesystems/volumes have entries , check count
# to check if file is changed or not. 0 - not changed , 1 - changed.
#@dummy is used to work around the /<str>/../<str>/ issue in perl. 
# to suite the need here. 

  my @dummy = storage::Utilities::getConfig("Collection Size");
  my @files = storage::Utilities::getConfig("FileSystems");
  my @disks = storage::Utilities::getConfig("Disks");
  my @volumes = storage::Utilities::getConfig("Volumes");

  my @limits  = storage::Utilities::getConfig("Collection Size");
  my $limit_chg = 0 ; #to check if limit is changed or not.

    foreach $entity (@limits)
    {
       my($name, $value) = split(/=/, $entity) ;
	if( (($name eq "Disks") ||($name eq "FileSystems" ) ) && ($value ne "100"))
        {
          $limit_chg = 1 ;
        }
        if(($name eq "Volumes") &&  ($value ne "10"))
        {
          $limit_chg = 1 ;
        }

    }

    #if limit has been changed and disks/fs/vol are entered then config file is changed. 
     if( ($limit_chg == 1) || ($#disks > 0) || ($#files > 0) || ($#volumes > 0) )
        { print "em_result=Config File|1\n";   }
      else
        { print "em_result=Config File|0\n";   }


