# $Header: emagent/sysman/admin/scripts/hostsyscalls.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:29 pnayak Exp $
#
# hostsyscalls.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      hostsyscalls.pl 
#
#    DESCRIPTION
#      returns system call activity as:
#       em_result=<num system calls per sec>|
#                 <num read or readv sys calls per sec>|
#                 <num write or writev sys calls per sec>|
#                 <num fork or forkv sys calls per sec>|
#                 <num exec sys calls per sec>|
#                 <num chars transfered by read sys call per sec>|
#                 <num chars transfered by write sys call per sec>
#
#    NOTES
#      data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar command system call stats.
#    aaitghez    05/18/01 - Creation
# 


$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";

# invoke sar
$r = `sar -c 5`
    or die "failed to execute sar";

#parse the return string into lines
@res = split(m/wchar\/s\n/, $r);
@values = split(m/[\t\s]+/, @res[1]);

print "em_result=@values[1]|@values[2]|@values[3]|@values[4]|@values[5]|@values[6]|@values[7]\n";
