# $Header: emagent/sysman/admin/scripts/hostsysswapswitch.pl /main/10 2011/07/12 00:34:07 cgnanasa Exp $
#
# hostsysswapswitch.pl
# 
# Copyright (c) 2001, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hostsysswapswitch.pl 
#
#    DESCRIPTION
#      returns system swapping and switching activity as:
#      em_result=<num system swapins per sec>|
#                <num system swapouts per sec>|
#                <num transfers for swapins 512bytes/s>|
#                <num transfers for swapouts 512bytes/s>|
#                <num process context switches>
#
#    NOTES
#      data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    cgnanasa    07/05/11 - get the instantaneous values
#    qding       03/15/05 - set locale to C 
#    sreddy      10/18/04 - fix compilation errors 
#    sacgoyal    10/14/04 - for fixing bug # 3845320 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar system swapping and switching activity.
#    aaitghez    05/18/01 - Creation
# 

$ENV{LC_ALL} = "C";
$ENV{PATH} = "/usr/bin:/bin:/usr/sbin:/usr/local/bin:/local/bin";

if($^O eq "SunOS" or $^O eq "solaris" or $^O eq "hpux")
{
  # invoke sar
  $r = `sar -w 5`
      or die "failed to execute sar";
  
  #parse the return string into lines
  @res = split(m/pswch\/s\n/, $r);
  @values = split(m/[\t\s]+/, @res[1]);
  
  print "em_result=@values[1]|@values[2]|@values[3]|@values[4]|@values[5]\n";

}
elsif ($^O eq "linux")
{
  # context switches per second
  @sarw = `sar -w 5` or die "Failed to run sar -w\n";
  ($ignore, $cswchps) = split(/\s+/, $sarw[$#sarw]);
  
  # swap ins per second and swap outs per second
  @sarW = `sar -W 5` or die "Failed to run sar -W\n";
  ($ignore, $pswpinps, $pswpoutps) = split(/\s+/, $sarW[$#sarW]);
  
  print "em_result=$pswpinps|$pswpoutps|0|0|$cswchps\n";

}
elsif ($^O eq "aix")
{
  @switch = `sar -w` or die "Unable to run sar\n";
  if ($#switch > 0)
  {
    ($ignore, $pswchps) = split(/\s+/, $switch[$#switch]);
  }
  $ignore =  $pswinsps = $pswoutps = 0;
  print "em_result=$pswinsps|$pswoutps|0|0|$pswchps\n";

}
else
{
  die "unsupported platform";
}

exit 0;
