# $Header: emagent/sysman/admin/scripts/hostttyactivity.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:40 pnayak Exp $
#
# hostttyactivity.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      hostttyactivity.pl 
#
#    DESCRIPTION
#      returns system tty activity as:
#      em_result=<num raw input characters per sec>|
#                <input chars processed by canon>|
#                <output chars per sec>|
#                <receive incoming char interrupts per sec>|
#                <transmit outgoing char interrupts per sec>|
#                <modem interrupt rate>
#                
#
#    NOTES
#      data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar tty activity stats.
#    aaitghez    05/18/01 - Creation
# 

$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";

# invoke sar
$r = `sar -y 5`
    or die "failed to execute sar";

#parse the return string into lines
@res = split(m/mdmin\/s\n/, $r);
@values = split(m/[\t\s]+/, @res[1]);

print "em_result=@values[1]|@values[2]|@values[3]|@values[4]|@values[5]|@values[6]\n";
