#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/hwcomponent.pl /main/1 2012/06/12 16:28:35 jshoup Exp $
#
# hwcomponent.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hwcomponent.pl - collects hw component data.
#
#   DESCRIPTION
#       Collects hardware component data
#       returns EM_RESULT =
# with values for
#| 'NAME';
#| 'MANUFACTURER';
#| 'TYPE';
#| 'SIZE_IN_BYTES';
#| 'PART_NUMBER';
#| 'SERIAL_NUMBER';
#| 'PCI_ID';
#| 'MODEL';
#| 'REVISION';
#| 'LOCATION';
#
#    NOTES
#      Currently only collects data for Solaris
#
#    MODIFIED   (MM/DD/YY)
#    jshoup      03/16/12 - Solaris hw componenet retrieval
#    jshoup      03/16/12 - Creation
# 

use strict;

use hostOSD;
use Config;

#######################################################
# Main routine.
#
# Currently only collects hw component data for Solaris
#
#######################################################
if ($Config{'osname'} eq "solaris")
{
    my @results = hostOSD::getSolarisHwComponents();
    for(my $i = 0; @results; $i++)
    {
        print shift @results;
    }
}

