# $Header: iasconfig.pl 29-dec-2005.05:58:45 jsmoler Exp $
#
# iasconfig.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#      iasconfig.pl - gets configuration information for an iAS instance
#
#    DESCRIPTION
#      iasconfig.pl <oracle_home> 
#
#      where:
#         <oracle_home> is the oracle home in which the iAS is installed
#
#    returns: 
#      em_result=<version>|<installType>
#
#      where:
#         <version> is the version number of the iAS is installation
#         <installType> is the type of installation, for example Core
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler    12/29/05 - special case 10.1.3 core install type 
#    klmichae   01/06/03 - remove infra DB properties
#    xxu        06/25/02 - remove /usr/local/bin/perl
#    klmichae   06/19/02 - klmichae_more_metrics1
#    klmichae   06/18/02 - Initial revision

use strict;

# open oracle_home/ias.properties 
my $propertyFileName = $ARGV[0]."/config/ias.properties";
if (!open (PROPFILE,$propertyFileName))
{ 
    print "em_result=||||\n";
    exit 0;
}

# Walk through all the lines looking for the install type and version 
#      em_result=<version>|<installType>
my $version = "";
my $installType = "";
my $name;
my $value;
my $nothing;
while(<PROPFILE>)
{
  # split apart the name and value.  Then, pull off the new line
  ($name, $value) = split(/=/, $_);
  if( defined( $value ) )
  {
    ($value, $nothing) = split("\n", $value);
  }
  
  # Pull off the properties that we are interested in
  if($name eq "Version"){
      $version=$value;
  }
  if($name eq "InstallType"){
      $installType=$value;
      
      # We need to differentiate the 10.1.3 'core' install type from the
      # 'Core' install type used in prior versions
      if ($version =~ /^10\.1\.3\./ && $installType eq 'core')
      {
	  $installType = 'core(javaOnly)';
      }
  }
}
close(PROPFILE);

print "em_result=$version|$installType\n";

