#!/usr/local/bin/perl
# 
# $Header: emcore/sysman/admin/scripts/jobutil/cleanup.pl /main/1 2010/10/08 01:20:31 rakerosh Exp $
#
# cleanup.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      cleanup.pl - Clean up the staging area.
#
#    DESCRIPTION
#      Clean up the staging area used in directive step in PAF
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rakerosh    09/27/10 - Creation
# 

use File::Path;
use lib ".";
use JobDiagUtil;

my $logInfo = "JobDiagUtil::logInfo";
my $loc = $ARGV[0];
if ('true' ne lc($ENV{'MGMT_PAF_DO_NOT_CLEANUP_FILES'}))
{
    &$logInfo("Cleaning up files after successful run...");
    rmtree($loc,1,0);
    &$logInfo("Successfully deleted all leftover files and directories. in directory $loc");
}
else
{
    &$logInfo("Skipping the clean up of files because environment variable MGMT_PAF_DO_NOT_CLEANUP_FILES is set to true...");
}
