#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/jobutil/invoke.pl /main/4 2012/01/20 05:06:38 amathur Exp $
#
# invoke.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      invoke.pl - Executes directive/component
#
#    DESCRIPTION
#      This perl file is called from the PafComponentStepJob jobtype to execute a component
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    amathur     01/17/12 - windows specific path sep changes
#    rakerosh    09/28/10 - Separated clean up process from invoke
#    rakerosh    08/16/10 - Creation
# 
use File::Basename;
use File::Copy;
use File::Path;
use lib ".";
use FindBin();
use lib "$FindBin::Bin";
use JobDiagUtil;

my $FileLocation ;
my $DirectiveFilename ;
my $DirectivePrefix ;
my $ComponentFilename ;
my $ComponentPrefix ;
my $CommandLinePrefix ;
my $ExecutorPrefix ;
my $EMDRoot ;
my $myPerlBinLoc ;
my $logInfo = "JobDiagUtil::logInfo";
my $pathSep ;

sub getPerlLibPath
{
    my $emdRoot = shift;
    my @perllibpath =
        (
         "$emdRoot/perl/lib",
         "$emdRoot/perl/libwww-perl/lib",
         "$emdRoot/perl/ext/POSIX",
         "$emdRoot/perl/URI",
         "$emdRoot/perl/HTML_Parser",
         "$emdRoot/perl/HTML-Parser/lib",
         "$emdRoot/bin",
         "$emdRoot/sysman/admin/scripts/Net-DNS-0.48/lib/",
         "$emdRoot/sysman/admin/scripts/libnet-1.19/",
         "$emdRoot/perl/lib/5.8.3",
         "$emdRoot/perl/lib/site_perl/5.8.3",
         "$emdRoot/perl/lib/site_perl",
         "$emdRoot/sysman/admin/scripts",
         "$emdRoot/perl/lib/site_perl/5.8.3/i686-linux-thread-multi",
         "$emdRoot/sysman/admin/scripts/jobutil",
         );

    return join($pathSep, @perllibpath);
}


sub setenv
{
    my $variable = shift;
    my $value = shift;
    my $override = shift || 1;

    if ($override or !$ENV{$variable})
    {
        $ENV{$variable} = $value;
    }
}

sub setenvpath
{
    my ($variable, $value) = @_;
    if (defined $ENV{$variable})
    {
        setenv ( $variable, $value . $pathSep . $ENV{$variable} );
    }
    else
    {
        setenv ( $variable, $value );
    }
}

sub parseArguments
{
    $FileLocation        = shift;
    $DirectiveFilename   = shift;
    $DirectivePrefix     = shift;
    $ComponentFilename   = shift;
    $ComponentPrefix     = shift;
    $CommandLinePrefix   = shift;
    $ExecutorPrefix      = shift;
    $EMDRoot             = shift;

    JobDiagUtil::logInfo <<CMD_ARGS;
FileLocation: $FileLocation
DirectiveFilename: $DirectiveFilename
DirectivePrefix: $DirectivePrefix
ComponentFilename: $ComponentFilename
ComponentPrefix: $ComponentPrefix
CommandLinePrefix: $CommandLinePrefix
ExecutorPrefix: $ExecutorPrefix
EMDRoot: $EMDRoot
CMD_ARGS
}

sub initenv 
{
    my $emdRoot = shift;

    if ( "$^O" =~ m/win/i )
    {
        $pathSep = ';';
    }
    else
    {
        $pathSep = ':';
    }

    setenv("EMDROOT", $emdRoot);
    setenvpath("PERL5LIB", getPerlLibPath($emdRoot));
    setenvpath("PERL5LIB", $FileLocation);
    setenv("AGENT_HOME",$emdRoot,0);
    setenv("PERL_BIN","$emdRoot/perl/bin",0);

    JobDiagUtil::logInfo <<ENV_VAR;
    EMDROOT: $ENV{'EMDROOT'}
    PERL5LIB: $ENV{'PERL5LIB'}
    AGENT_HOME: $ENV{'AGENT_HOME'}
    PERL_BIN: $ENV{'PERL_BIN'}
ENV_VAR
}

sub formCommandToExecute
{
    my $myComponentFilename = (length($ComponentFilename) > 0) ? $ComponentFilename : "null";
    my $myComponentBinaryFilename = (length($ComponentFilename) > 0) ? $FileLocation."/".$ComponentFilename : "null";
    my $myPerl = 'perl';
    my @cmd = ("-I", 
               $EMDRoot."/perl/lib", 
               $EMDRoot."/sysman/admin/scripts/provisioning/provisionExecutor.pl",
               "-executorpropertyfilename", 
               $EMDRoot."/sysman/admin/scripts/provisioning/provision.properties",
               "-componentpath",
               $ComponentPrefix,
               "-directivepath", 
               $DirectivePrefix,
               "-directivescriptfilepath",
               $FileLocation."/".$DirectiveFilename,
               "-propertyfilepath", 
               $FileLocation."/properties", 
               "-component_binaryfilename", 
               $myComponentBinaryFilename,
               "-cmdline_propertyname",
               $CommandLinePrefix, 
               "-directivetype_propertyname",
               $ExecutorPrefix,
               "-emdroot", 
               $EMDRoot );

    if ( -e  $myPerlBinLoc."/perl" ||  -e  $myPerlBinLoc."/perl.exe")
    {
        $myPerl = "$myPerlBinLoc/perl";
        push(@cmd,
             "-perlhome");
        push(@cmd,
             $myPerlBinLoc);

    }

    unshift(@cmd,$myPerl);
    return @cmd;

}

sub restructurePropFile
{
    my $location = shift;
    my $perlLoc = shift;
    my $myPropsFileTemp = $location."/properties.paf";
    my $myPropsFile = $location."/properties";
    open (IN, "<$myPropsFile");
    open (OUT, ">$myPropsFileTemp");
    while (<IN>)
    {
        s/\@perlbin\@/$perlLoc/ ;
        print OUT;
    }
    close IN;
    close OUT;
    move($myPropsFileTemp, $myPropsFile);
}

sub execute
{
    my @cmd = formCommandToExecute();
    my $rc = system(@cmd);
    return $rc;
}

parseArguments(@ARGV);
initenv($EMDRoot);

if ( -e  $FileLocation."/setup_env" )
{
    require  $FileLocation."/setup_env";
}

$myPerlBinLoc = dirname $^X;
restructurePropFile($FileLocation,$myPerlBinLoc);
my $rc = execute();
$rc = 0xFFFF & $rc ;
$rc >>= 8;

exit $rc;
